// Test script to verify player update functionality
const fetch = require('node-fetch');

async function testPlayerUpdate() {
  try {
    // First, login to get a valid session
    const loginResponse = await fetch('http://localhost:5000/api/auth/login', {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify({
        email: 'demo@rugby.com',
        password: 'demo123'
      }),
      credentials: 'include'
    });

    console.log('Login status:', loginResponse.status);
    
    if (!loginResponse.ok) {
      console.log('Login failed:', await loginResponse.text());
      return;
    }

    // Extract session cookie
    const cookies = loginResponse.headers.get('set-cookie');
    console.log('Session cookies:', cookies);

    // Test player update with PATCH
    const updateResponse = await fetch('http://localhost:5000/api/players/17', {
      method: 'PATCH',
      headers: {
        'Content-Type': 'application/json',
        'Cookie': cookies || ''
      },
      body: JSON.stringify({
        position: 'Test Position Update'
      })
    });

    console.log('Update status:', updateResponse.status);
    const updateResult = await updateResponse.text();
    console.log('Update response:', updateResult);

  } catch (error) {
    console.error('Test error:', error);
  }
}

testPlayerUpdate();