# SportsPro - Sports Management Platform

## Overview
SportsPro is an enterprise-grade sports management platform for professional organizations. It offers comprehensive team management, including roster, player, and coaching tools, advanced analytics, and subscription management. The platform aims to provide a robust solution for managing various aspects of sports operations, from player performance tracking to communication and financial management. Key capabilities include multi-sport support, AI-powered smart onboarding, biometric data privacy, and a one-click performance video highlight generator.

## Recent Changes (October 2025)
- **Comprehensive UI Revamp (October 2025)**: Complete professional redesign of the platform UI for enterprise-grade appearance and user experience
  - **Design System Overhaul**: Implemented standardized color palette with proper HSL values, professional blue primary (220 91% 56%), dark sidebar theme (215 28% 17%), and consistent accessibility tokens for light/dark modes
  - **Navigation Shell Redesign**: Modern gradient logo in header with dark mode toggle, notification badge, and enhanced user dropdown. Professional dark sidebar (slate-800) with improved organization, smooth collapse/expand animations, hover effects, and active state indicators
  - **Dashboard Transformation**: Modern gradient background, professional stat cards with gradient overlays (blue, green, purple, orange), enhanced team cards with hover effects and gradient accents, improved visual hierarchy, skeleton loaders for better perceived performance
  - **Loading States & Skeleton UI**: Comprehensive skeleton loaders throughout the application for improved user experience during data fetching
  - **Consistent Table Patterns**: Standardized search, filters, grid/list views, and empty states across all data tables (teams, players, coaches)
- **Self-Contained Installation Wizard (October 2025)**: Implemented auto-installer system accessible at `/installation` with two-step flow: database connectivity testing and automated super admin user creation. Creates `.installed` marker file, uses bcrypt password hashing, and provides clean UI for initial setup
- **Module Management System (October 2025)**: Built comprehensive module management system allowing super admins to enable/disable platform modules globally with 24 modules across 5 categories
- **Enhanced Stack Implementation (October 2025)**: Added Redis for caching (with graceful degradation), Socket.io for real-time updates, Bull for background jobs, and Replit Object Storage for file management
- **User Settings & Preferences (October 2025)**: Implemented comprehensive user settings page with 6 sections: Profile Info, Password Management, Notification Preferences, Theme & Layout customization, Subscription Management, and Privacy & Security Settings. Accessible from both profile dropdown and sidebar.
- **Audit Logging System Implemented (October 2025)**: Created audit trail system tracking all admin actions with filtering, search, and detailed log viewing capabilities
- **Reports & Analytics Module Added (October 2025)**: Built analytics dashboard with fixtures reports, attendance tracking, revenue analysis, and top performers rankings with CSV export functionality
- **Notification System Implemented (October 2025)**: Added comprehensive notification center with multi-channel support (email, in-app, SMS-ready), notification management UI, and real-time updates
- **Branding Settings Added (January 2025)**: Added comprehensive Branding Settings page with logo/favicon upload, color customization, social media links, custom CSS/JS, and SEO settings
- **Language & Timezone Settings Added (January 2025)**: Added Language Settings page with timezone configuration, date/time formats, and localization options
- **New Security Features Added (January 2025)**: Added comprehensive Security page with 2FA, password resets, activity logs, and session management
- **Widget System Removed (January 2025)**: Completely removed all dashboard widget functionality as requested by user
- **Architecture Simplification (January 2025)**: Streamlined codebase by removing widget-related components, routes, and storage methods. Removed dashboardWidgets table and all related code.
- **Comprehensive Security Audit & Hardening (October 2025)**: Conducted full security audit and implemented critical fixes:
  - **Session Security**: Removed SESSION_SECRET default fallback; application now requires explicit environment variable. Added sameSite: 'strict' cookie policy to prevent CSRF attacks
  - **Password Security**: Removed plaintext passwords from welcome emails; users now use secure password reset flow. Password reset tokens no longer exposed in API responses
  - **Route Protection**: Added authentication middleware to all sensitive endpoints (debug routes, theme management, import/export, installation endpoints). Installation routes protected after initial setup with requireNotInstalled middleware
  - **Admin Access Control**: Debug endpoints protected with requireAuth and requireAdmin middleware. Export/import functionality restricted to authenticated users only
  - **Input Validation**: All API routes use Zod schema validation for request bodies, protecting against SQL injection and malformed data

## User Preferences
Preferred communication style: Simple, everyday language.

## System Architecture

### UI/UX Decisions
The platform features a modern, professional design with an emphasis on intuitive user experience. UI components leverage Radix UI with Tailwind CSS for styling, ensuring accessibility and responsiveness. Design patterns include gradient headers, glass-morphism effects, and a variety of attractive form designs (18 themes including Modern Gradient, Minimalist Clean, Dark Mode, etc.). The interface is responsive across all devices, with a professional sidebar toggle, optimized text sizing, and flexible layouts. Player detail views feature fully responsive card-based layouts with responsive grid systems (1 col mobile, 2 cols tablet, 3 cols desktop) and adaptive typography scaling.

### Technical Implementations
**Frontend:** Built with React 18 and TypeScript, using Vite for development and optimized builds. State management is handled by TanStack Query, routing by Wouter, and forms by React Hook Form with Zod validation. Interactive features like roster management utilize @dnd-kit. Real-time features powered by Socket.io client.
**Backend:** Developed with Node.js 20.x and Express.js. It features a robust authentication system using Passport.js with session management, Multer for file uploads, and SendGrid for email communications. PM2 is used for process management in production.
**Database & Caching:** PostgreSQL serves as the primary relational database, managed with Drizzle ORM for type-safe operations. Redis provides caching for live match data, leaderboards, and session storage with automatic retry logic.
**Real-time & Background Jobs:** Socket.io WebSocket server enables real-time match updates, team notifications, and live scoring. Bull queue system handles background processing for email delivery, report generation, and notifications with automatic retry and error handling.
**File Storage:** Replit Object Storage (Google Cloud Storage) for secure file uploads including player photos, match videos, documents, and media files with ACL-based access control.
**Key Features:**
- **Installation Wizard:** Self-contained auto-installer accessible at `/installation` for first-time setup. Two-step wizard tests database connectivity and creates organization with super admin account. Uses `.installed` file marker for state tracking, bcrypt password hashing, and automatic redirect to login on completion.
- **Authentication & Authorization:** Multi-role authentication (Administrator, Coach, User/Viewer) with session-based and role-based access control.
- **Team Management:** Organization-based team structures, player/coach registration, position management, and performance tracking.
- **Roster Management:** Interactive drag-and-drop roster assignment with formation support for multiple sports. Includes advanced search, filtering, bulk actions, and import/export.
- **Notification System:** Multi-channel notification center supporting email, in-app notifications, and SMS (with future Twilio integration). Features real-time updates, mark as read/unread, and notification management.
- **Reports & Analytics:** Comprehensive analytics module with fixtures per month reports, attendance tracking, revenue analysis, and top scorers/performers rankings. Includes CSV export functionality for all reports.
- **Audit & Logging:** Complete audit trail system tracking all administrative actions (create, update, delete) with filtering by action type, resource, user, and date range. Includes detailed log viewing with IP address, user agent, and change tracking.
- **User Settings & Preferences:** Comprehensive settings management with profile editing, password changes (with bcrypt verification), notification preferences (email/SMS/push), theme customization (color scheme, font size, layout density), subscription management, and privacy controls (profile visibility, data sharing). Stored in userPreferences table with automatic defaults.
- **Communication System:** Club news, event management, announcements, and automated email notifications.
- **Payment & Subscription:** Organization-based subscription tiers, membership fee tracking, and integration with multiple payment gateways.
- **Smart Onboarding:** AI-powered sport-specific analysis providing dynamic recommendations and a setup scoring system.
- **Biometric Data Privacy:** One-click privacy settings with presets and granular controls for data collection and sharing.
- **CMS:** A comprehensive Content Management System allowing super admins to edit all landing page content dynamically from the dashboard.

### System Design Choices
The architecture emphasizes modularity, scalability, and security. Data flows are well-defined for user authentication, player management, and roster updates, utilizing optimistic UI updates and real-time synchronization where appropriate. Performance optimizations include server-side gzip compression, API caching, and lazy loading components. Deployment strategies support both Replit-based development and production VPS environments with Nginx and PM2.

## External Dependencies

### Frontend
- **UI & Styling:** Radix UI, Tailwind CSS
- **Data Visualization:** Recharts
- **Date Handling:** date-fns
- **PDF Generation:** jsPDF
- **Interactive Features:** @dnd-kit

### Backend
- **Database Connection:** @neondatabase/serverless
- **ORM:** Drizzle ORM
- **Authentication:** Passport.js
- **Email:** @sendgrid/mail
- **File Upload:** Multer, @uppy/core for client-side uploads
- **Session Management:** express-session with PostgreSQL store
- **Caching:** Redis (ioredis) for session storage and data caching
- **Real-time:** Socket.io for WebSocket connections
- **Background Jobs:** Bull queue system for async processing
- **Cloud Storage:** @google-cloud/storage (Replit Object Storage)

### Payment Gateways
- Stripe
- PayPal
- Flutterwave
- Paystack
- Paytm
- CoinGate
- SSPay
- PayUMoney
- Razorpay