import { Button } from "@/components/ui/button";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Badge } from "@/components/ui/badge";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";
import { 
  Trophy, Users, BarChart3, Shield, Clock, Heart, Menu, X,
  Video, Brain, Fingerprint, Palette, Calendar, CreditCard,
  Target, Zap, Star, CheckCircle, PlayCircle, ArrowRight,
  Sparkles, Rocket, Camera, Settings, TrendingUp, Award,
  Globe, Smartphone, Monitor, Database
} from "lucide-react";
import { useState } from "react";

export default function ServicesPage() {
  const [mobileMenuOpen, setMobileMenuOpen] = useState(false);
  const [activeTab, setActiveTab] = useState("ai-features");

  return (
    <div className="min-h-screen bg-gradient-to-br from-slate-50 via-white to-slate-50">
      {/* Header */}
      <header className="sticky top-0 z-50 border-b bg-white/80 backdrop-blur-lg shadow-sm">
        <div className="container mx-auto px-4 py-4">
          <div className="flex items-center justify-between">
            <div className="flex items-center space-x-3">
              <div className="w-12 h-12 bg-gradient-to-br from-primary to-purple-600 rounded-xl flex items-center justify-center shadow-lg">
                <Trophy className="h-7 w-7 text-white" />
              </div>
              <div>
                <h1 className="text-2xl font-bold bg-gradient-to-r from-gray-900 to-gray-700 bg-clip-text text-transparent">
                  SportsPro
                </h1>
                <p className="text-xs text-gray-500 font-medium">Professional Sports Management</p>
              </div>
            </div>
            
            {/* Desktop Navigation */}
            <nav className="hidden lg:flex items-center space-x-8">
              <a href="/" className="text-gray-600 hover:text-primary transition-colors font-medium">Home</a>
              <a href="/about" className="text-gray-600 hover:text-primary transition-colors font-medium">About</a>
              <a href="/services" className="text-primary font-semibold">Features</a>
              <a href="/contact" className="text-gray-600 hover:text-primary transition-colors font-medium">Contact</a>
              <div className="h-6 w-px bg-gray-200"></div>
              <Button variant="outline" className="font-medium">Sign In</Button>
            </nav>
            
            <div className="flex items-center space-x-3">
              <Button 
                onClick={() => window.location.href = "/auth"} 
                size="lg" 
                className="hidden sm:inline-flex bg-gradient-to-r from-primary to-purple-600 hover:from-primary/90 hover:to-purple-600/90 font-semibold shadow-lg"
              >
                Get Started Free
                <ArrowRight className="ml-2 h-4 w-4" />
              </Button>
              
              {/* Mobile menu button */}
              <Button
                variant="outline"
                size="sm"
                className="lg:hidden"
                onClick={() => setMobileMenuOpen(!mobileMenuOpen)}
              >
                {mobileMenuOpen ? <X className="h-4 w-4" /> : <Menu className="h-4 w-4" />}
              </Button>
            </div>
          </div>
          
          {/* Mobile Navigation */}
          {mobileMenuOpen && (
            <div className="lg:hidden mt-4 pt-4 border-t bg-white rounded-lg shadow-lg">
              <nav className="flex flex-col space-y-3 p-4">
                <a href="/" className="text-gray-600 hover:text-primary transition-colors py-2">Home</a>
                <a href="/about" className="text-gray-600 hover:text-primary transition-colors py-2">About</a>
                <a href="/services" className="text-primary font-semibold py-2">Features</a>
                <a href="/contact" className="text-gray-600 hover:text-primary transition-colors py-2">Contact</a>
                <div className="pt-2">
                  <Button onClick={() => window.location.href = "/auth"} className="w-full">
                    Get Started Free
                  </Button>
                </div>
              </nav>
            </div>
          )}
        </div>
      </header>

      {/* Hero Section */}
      <section className="py-20 lg:py-32">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto text-center">
            <Badge className="bg-gradient-to-r from-primary to-purple-600 text-white border-0 shadow-lg mb-6">
              <Sparkles className="h-3 w-3 mr-1" />
              Platform Features
            </Badge>
            <h1 className="text-5xl lg:text-6xl font-bold leading-tight mb-6">
              <span className="bg-gradient-to-r from-gray-900 via-primary to-purple-600 bg-clip-text text-transparent">
                Comprehensive
              </span>
              <br />
              <span className="text-gray-900">Sports Management</span>
            </h1>
            <p className="text-xl text-gray-600 leading-relaxed max-w-3xl mx-auto mb-8">
              Discover all the powerful features that make SportsPro the most advanced sports 
              management platform, from AI-powered video analysis to enterprise-grade security.
            </p>
            
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <Button 
                size="lg" 
                onClick={() => window.location.href = "/auth"}
                className="bg-gradient-to-r from-primary to-purple-600 hover:from-primary/90 hover:to-purple-600/90 text-lg px-8 py-4 shadow-xl"
              >
                Try All Features
                <Rocket className="ml-2 h-5 w-5" />
              </Button>
              <Button 
                size="lg" 
                variant="outline" 
                className="text-lg px-8 py-4 border-2 border-primary text-primary hover:bg-primary hover:text-white transition-all font-semibold"
              >
                <PlayCircle className="mr-2 h-5 w-5" />
                Watch Demo
              </Button>
            </div>
          </div>
        </div>
      </section>

      {/* Features Tabs */}
      <section className="py-20 bg-gray-50">
        <div className="container mx-auto px-4">
          <div className="max-w-6xl mx-auto">
            <Tabs value={activeTab} onValueChange={setActiveTab} className="w-full">
              <TabsList className="grid w-full grid-cols-2 lg:grid-cols-4 mb-12">
                <TabsTrigger value="ai-features" className="text-sm">AI Features</TabsTrigger>
                <TabsTrigger value="management" className="text-sm">Team Management</TabsTrigger>
                <TabsTrigger value="security" className="text-sm">Security</TabsTrigger>
                <TabsTrigger value="customization" className="text-sm">Customization</TabsTrigger>
              </TabsList>
              
              <TabsContent value="ai-features" className="space-y-8">
                <div className="text-center mb-12">
                  <h2 className="text-4xl font-bold text-gray-900 mb-4">AI-Powered Intelligence</h2>
                  <p className="text-xl text-gray-600 max-w-3xl mx-auto">
                    Revolutionary artificial intelligence features that automate complex tasks and provide intelligent insights
                  </p>
                </div>
                
                <div className="grid lg:grid-cols-2 gap-8">
                  <Card className="border-0 shadow-xl">
                    <CardHeader className="bg-gradient-to-r from-purple-50 to-pink-50">
                      <div className="flex items-center space-x-3">
                        <div className="w-12 h-12 bg-gradient-to-br from-purple-500 to-pink-500 rounded-xl flex items-center justify-center">
                          <Video className="h-6 w-6 text-white" />
                        </div>
                        <div>
                          <CardTitle className="text-xl">AI Video Highlights</CardTitle>
                          <CardDescription>Automated highlight generation</CardDescription>
                        </div>
                      </div>
                    </CardHeader>
                    <CardContent className="p-6">
                      <ul className="space-y-3">
                        <li className="flex items-center">
                          <CheckCircle className="h-4 w-4 text-green-500 mr-3" />
                          <span>Automatic detection of goals, assists, saves, and key plays</span>
                        </li>
                        <li className="flex items-center">
                          <CheckCircle className="h-4 w-4 text-green-500 mr-3" />
                          <span>Professional quality outputs in HD, Full HD, and 4K</span>
                        </li>
                        <li className="flex items-center">
                          <CheckCircle className="h-4 w-4 text-green-500 mr-3" />
                          <span>Custom transitions, effects, and music integration</span>
                        </li>
                        <li className="flex items-center">
                          <CheckCircle className="h-4 w-4 text-green-500 mr-3" />
                          <span>Real-time progress tracking and batch processing</span>
                        </li>
                      </ul>
                    </CardContent>
                  </Card>
                  
                  <Card className="border-0 shadow-xl">
                    <CardHeader className="bg-gradient-to-r from-blue-50 to-cyan-50">
                      <div className="flex items-center space-x-3">
                        <div className="w-12 h-12 bg-gradient-to-br from-blue-500 to-cyan-500 rounded-xl flex items-center justify-center">
                          <Brain className="h-6 w-6 text-white" />
                        </div>
                        <div>
                          <CardTitle className="text-xl">Smart Onboarding</CardTitle>
                          <CardDescription>AI-powered setup guidance</CardDescription>
                        </div>
                      </div>
                    </CardHeader>
                    <CardContent className="p-6">
                      <ul className="space-y-3">
                        <li className="flex items-center">
                          <CheckCircle className="h-4 w-4 text-green-500 mr-3" />
                          <span>Sport-specific setup recommendations</span>
                        </li>
                        <li className="flex items-center">
                          <CheckCircle className="h-4 w-4 text-green-500 mr-3" />
                          <span>Intelligent analysis of team composition and needs</span>
                        </li>
                        <li className="flex items-center">
                          <CheckCircle className="h-4 w-4 text-green-500 mr-3" />
                          <span>Progress tracking with setup scoring (0-100)</span>
                        </li>
                        <li className="flex items-center">
                          <CheckCircle className="h-4 w-4 text-green-500 mr-3" />
                          <span>Personalized feature prioritization</span>
                        </li>
                      </ul>
                    </CardContent>
                  </Card>
                  
                  <Card className="border-0 shadow-xl">
                    <CardHeader className="bg-gradient-to-r from-green-50 to-emerald-50">
                      <div className="flex items-center space-x-3">
                        <div className="w-12 h-12 bg-gradient-to-br from-green-500 to-emerald-500 rounded-xl flex items-center justify-center">
                          <TrendingUp className="h-6 w-6 text-white" />
                        </div>
                        <div>
                          <CardTitle className="text-xl">Predictive Analytics</CardTitle>
                          <CardDescription>AI-driven performance insights</CardDescription>
                        </div>
                      </div>
                    </CardHeader>
                    <CardContent className="p-6">
                      <ul className="space-y-3">
                        <li className="flex items-center">
                          <CheckCircle className="h-4 w-4 text-green-500 mr-3" />
                          <span>Performance prediction and trend analysis</span>
                        </li>
                        <li className="flex items-center">
                          <CheckCircle className="h-4 w-4 text-green-500 mr-3" />
                          <span>Injury risk assessment and prevention</span>
                        </li>
                        <li className="flex items-center">
                          <CheckCircle className="h-4 w-4 text-green-500 mr-3" />
                          <span>Team outcome forecasting</span>
                        </li>
                        <li className="flex items-center">
                          <CheckCircle className="h-4 w-4 text-green-500 mr-3" />
                          <span>Data-driven recommendation engine</span>
                        </li>
                      </ul>
                    </CardContent>
                  </Card>
                  
                  <Card className="border-0 shadow-xl">
                    <CardHeader className="bg-gradient-to-r from-orange-50 to-red-50">
                      <div className="flex items-center space-x-3">
                        <div className="w-12 h-12 bg-gradient-to-br from-orange-500 to-red-500 rounded-xl flex items-center justify-center">
                          <Target className="h-6 w-6 text-white" />
                        </div>
                        <div>
                          <CardTitle className="text-xl">Smart Recommendations</CardTitle>
                          <CardDescription>Intelligent feature suggestions</CardDescription>
                        </div>
                      </div>
                    </CardHeader>
                    <CardContent className="p-6">
                      <ul className="space-y-3">
                        <li className="flex items-center">
                          <CheckCircle className="h-4 w-4 text-green-500 mr-3" />
                          <span>Context-aware feature recommendations</span>
                        </li>
                        <li className="flex items-center">
                          <CheckCircle className="h-4 w-4 text-green-500 mr-3" />
                          <span>Workflow optimization suggestions</span>
                        </li>
                        <li className="flex items-center">
                          <CheckCircle className="h-4 w-4 text-green-500 mr-3" />
                          <span>Performance improvement insights</span>
                        </li>
                        <li className="flex items-center">
                          <CheckCircle className="h-4 w-4 text-green-500 mr-3" />
                          <span>Automated best practice implementation</span>
                        </li>
                      </ul>
                    </CardContent>
                  </Card>
                </div>
              </TabsContent>
              
              <TabsContent value="management" className="space-y-8">
                <div className="text-center mb-12">
                  <h2 className="text-4xl font-bold text-gray-900 mb-4">Complete Team Management</h2>
                  <p className="text-xl text-gray-600 max-w-3xl mx-auto">
                    Comprehensive tools for managing every aspect of your sports organization
                  </p>
                </div>
                
                <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
                  {[
                    {
                      icon: <Users className="h-8 w-8 text-blue-600" />,
                      title: "Player Management",
                      description: "Complete player profiles with biometric data, performance tracking, and contact management",
                      features: ["Advanced search & filtering", "Bulk operations", "Performance analytics", "Attendance tracking"]
                    },
                    {
                      icon: <Award className="h-8 w-8 text-green-600" />,
                      title: "Coach Management",
                      description: "Comprehensive coaching tools with team assignments and performance evaluation",
                      features: ["Coach profiles", "Team relationships", "Feedback systems", "Training planning"]
                    },
                    {
                      icon: <Calendar className="h-8 w-8 text-purple-600" />,
                      title: "Event Scheduling",
                      description: "Advanced scheduling with automated notifications and attendance tracking",
                      features: ["Match scheduling", "Training sessions", "Automated reminders", "Conflict detection"]
                    },
                    {
                      icon: <BarChart3 className="h-8 w-8 text-orange-600" />,
                      title: "Performance Analytics",
                      description: "Real-time dashboards with comprehensive statistics and reporting",
                      features: ["Live statistics", "Custom reports", "Trend analysis", "Performance metrics"]
                    },
                    {
                      icon: <Target className="h-8 w-8 text-red-600" />,
                      title: "Roster Management",
                      description: "Dynamic roster organization with position management and formation support",
                      features: ["Drag & drop interface", "Position assignments", "Formation templates", "Substitute management"]
                    },
                    {
                      icon: <Heart className="h-8 w-8 text-pink-600" />,
                      title: "Health & Wellness",
                      description: "Comprehensive health tracking with injury management and prevention",
                      features: ["Injury tracking", "Medical records", "Fitness monitoring", "Recovery planning"]
                    }
                  ].map((feature, index) => (
                    <Card key={index} className="border-0 shadow-lg hover:shadow-xl transition-all">
                      <CardContent className="p-6">
                        <div className="w-12 h-12 bg-gray-100 rounded-xl flex items-center justify-center mb-4">
                          {feature.icon}
                        </div>
                        <h3 className="text-xl font-bold text-gray-900 mb-2">{feature.title}</h3>
                        <p className="text-gray-600 mb-4">{feature.description}</p>
                        <ul className="space-y-1">
                          {feature.features.map((item, idx) => (
                            <li key={idx} className="flex items-center text-sm text-gray-600">
                              <CheckCircle className="h-3 w-3 text-green-500 mr-2" />
                              {item}
                            </li>
                          ))}
                        </ul>
                      </CardContent>
                    </Card>
                  ))}
                </div>
              </TabsContent>
              
              <TabsContent value="security" className="space-y-8">
                <div className="text-center mb-12">
                  <h2 className="text-4xl font-bold text-gray-900 mb-4">Enterprise Security</h2>
                  <p className="text-xl text-gray-600 max-w-3xl mx-auto">
                    Bank-level security with advanced biometric authentication and comprehensive privacy controls
                  </p>
                </div>
                
                <div className="grid lg:grid-cols-2 gap-8">
                  <Card className="border-0 shadow-xl">
                    <CardHeader className="bg-gradient-to-r from-green-50 to-emerald-50">
                      <div className="flex items-center space-x-3">
                        <div className="w-12 h-12 bg-gradient-to-br from-green-500 to-emerald-500 rounded-xl flex items-center justify-center">
                          <Fingerprint className="h-6 w-6 text-white" />
                        </div>
                        <div>
                          <CardTitle className="text-xl">Biometric Authentication</CardTitle>
                          <CardDescription>Advanced facial recognition security</CardDescription>
                        </div>
                      </div>
                    </CardHeader>
                    <CardContent className="p-6 space-y-4">
                      <div className="space-y-3">
                        <div className="flex items-center">
                          <Camera className="h-5 w-5 text-green-600 mr-3" />
                          <span className="font-medium">Real-time Face Detection</span>
                        </div>
                        <p className="text-gray-600 text-sm ml-8">
                          Advanced facial recognition with liveness verification to prevent spoofing
                        </p>
                      </div>
                      
                      <div className="space-y-3">
                        <div className="flex items-center">
                          <Shield className="h-5 w-5 text-green-600 mr-3" />
                          <span className="font-medium">Secure Data Encryption</span>
                        </div>
                        <p className="text-gray-600 text-sm ml-8">
                          End-to-end encryption for all biometric data with secure storage protocols
                        </p>
                      </div>
                      
                      <div className="space-y-3">
                        <div className="flex items-center">
                          <Database className="h-5 w-5 text-green-600 mr-3" />
                          <span className="font-medium">Privacy by Design</span>
                        </div>
                        <p className="text-gray-600 text-sm ml-8">
                          Built-in privacy controls with granular access permissions
                        </p>
                      </div>
                    </CardContent>
                  </Card>
                  
                  <Card className="border-0 shadow-xl">
                    <CardHeader className="bg-gradient-to-r from-blue-50 to-cyan-50">
                      <div className="flex items-center space-x-3">
                        <div className="w-12 h-12 bg-gradient-to-br from-blue-500 to-cyan-500 rounded-xl flex items-center justify-center">
                          <Settings className="h-6 w-6 text-white" />
                        </div>
                        <div>
                          <CardTitle className="text-xl">Privacy Controls</CardTitle>
                          <CardDescription>Comprehensive data protection</CardDescription>
                        </div>
                      </div>
                    </CardHeader>
                    <CardContent className="p-6">
                      <div className="space-y-4">
                        <div className="bg-gray-50 p-4 rounded-lg">
                          <h4 className="font-semibold text-gray-900 mb-2">Privacy Presets</h4>
                          <ul className="space-y-2 text-sm text-gray-600">
                            <li>• <strong>Maximum Privacy:</strong> Strict access controls and minimal data sharing</li>
                            <li>• <strong>Balanced:</strong> Optimized balance between privacy and functionality</li>
                            <li>• <strong>Open Access:</strong> Enhanced collaboration with controlled sharing</li>
                          </ul>
                        </div>
                        
                        <div className="bg-gray-50 p-4 rounded-lg">
                          <h4 className="font-semibold text-gray-900 mb-2">Data Controls</h4>
                          <ul className="space-y-2 text-sm text-gray-600">
                            <li>• Configurable data collection with opt-in/opt-out controls</li>
                            <li>• Granular sharing permissions for different user roles</li>
                            <li>• Automated data deletion with customizable retention periods</li>
                            <li>• Real-time privacy status monitoring and alerts</li>
                          </ul>
                        </div>
                      </div>
                    </CardContent>
                  </Card>
                </div>
              </TabsContent>
              
              <TabsContent value="customization" className="space-y-8">
                <div className="text-center mb-12">
                  <h2 className="text-4xl font-bold text-gray-900 mb-4">Platform Customization</h2>
                  <p className="text-xl text-gray-600 max-w-3xl mx-auto">
                    Personalize your platform with professional themes, custom forms, and global payment solutions
                  </p>
                </div>
                
                <div className="grid md:grid-cols-3 gap-8">
                  <Card className="border-0 shadow-xl">
                    <CardHeader className="bg-gradient-to-r from-pink-50 to-purple-50">
                      <div className="w-12 h-12 bg-gradient-to-br from-pink-500 to-purple-500 rounded-xl flex items-center justify-center mb-4">
                        <Palette className="h-6 w-6 text-white" />
                      </div>
                      <CardTitle className="text-xl">18 Professional Themes</CardTitle>
                      <CardDescription>Beautiful designs for every organization</CardDescription>
                    </CardHeader>
                    <CardContent className="p-6">
                      <div className="grid grid-cols-2 gap-2 mb-4">
                        {[
                          "Modern Gradient", "Minimalist Clean", "Sports Dynamic", "Corporate Professional",
                          "Creative Colorful", "Education Friendly", "Healthcare Calm", "Event Festive"
                        ].map((theme, index) => (
                          <div key={index} className="text-xs bg-gray-100 rounded px-2 py-1 text-center">
                            {theme}
                          </div>
                        ))}
                      </div>
                      <ul className="space-y-2 text-sm text-gray-600">
                        <li>• Custom color schemes and gradients</li>
                        <li>• Logo and branding integration</li>
                        <li>• Mobile-responsive designs</li>
                        <li>• Live preview functionality</li>
                      </ul>
                    </CardContent>
                  </Card>
                  
                  <Card className="border-0 shadow-xl">
                    <CardHeader className="bg-gradient-to-r from-blue-50 to-cyan-50">
                      <div className="w-12 h-12 bg-gradient-to-br from-blue-500 to-cyan-500 rounded-xl flex items-center justify-center mb-4">
                        <Monitor className="h-6 w-6 text-white" />
                      </div>
                      <CardTitle className="text-xl">Advanced Form Builder</CardTitle>
                      <CardDescription>Drag-and-drop form creation</CardDescription>
                    </CardHeader>
                    <CardContent className="p-6">
                      <ul className="space-y-3 text-sm text-gray-600">
                        <li className="flex items-center">
                          <CheckCircle className="h-4 w-4 text-green-500 mr-2" />
                          Drag-and-drop field creation
                        </li>
                        <li className="flex items-center">
                          <CheckCircle className="h-4 w-4 text-green-500 mr-2" />
                          Multi-language support (RTL included)
                        </li>
                        <li className="flex items-center">
                          <CheckCircle className="h-4 w-4 text-green-500 mr-2" />
                          Email notifications and automation
                        </li>
                        <li className="flex items-center">
                          <CheckCircle className="h-4 w-4 text-green-500 mr-2" />
                          Data export and import functionality
                        </li>
                        <li className="flex items-center">
                          <CheckCircle className="h-4 w-4 text-green-500 mr-2" />
                          Security features with data sanitization
                        </li>
                      </ul>
                    </CardContent>
                  </Card>
                  
                  <Card className="border-0 shadow-xl">
                    <CardHeader className="bg-gradient-to-r from-green-50 to-emerald-50">
                      <div className="w-12 h-12 bg-gradient-to-br from-green-500 to-emerald-500 rounded-xl flex items-center justify-center mb-4">
                        <CreditCard className="h-6 w-6 text-white" />
                      </div>
                      <CardTitle className="text-xl">9 Payment Gateways</CardTitle>
                      <CardDescription>Global payment processing</CardDescription>
                    </CardHeader>
                    <CardContent className="p-6">
                      <div className="grid grid-cols-3 gap-2 mb-4">
                        {[
                          "Stripe", "PayPal", "Flutterwave", "Paystack", "Paytm", 
                          "CoinGate", "SSPay", "PayUMoney", "Razorpay"
                        ].map((gateway, index) => (
                          <div key={index} className="text-xs bg-gray-100 rounded px-2 py-1 text-center">
                            {gateway}
                          </div>
                        ))}
                      </div>
                      <ul className="space-y-2 text-sm text-gray-600">
                        <li>• Sandbox and live mode switching</li>
                        <li>• Fee configuration and tracking</li>
                        <li>• Connection testing and monitoring</li>
                        <li>• Multi-currency support</li>
                      </ul>
                    </CardContent>
                  </Card>
                </div>
              </TabsContent>
            </Tabs>
          </div>
        </div>
      </section>

      {/* Integration Section */}
      <section className="py-20">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto text-center">
            <h2 className="text-4xl font-bold text-gray-900 mb-4">Works Everywhere</h2>
            <p className="text-xl text-gray-600 mb-12">
              Access SportsPro from any device, anywhere in the world
            </p>
            
            <div className="grid md:grid-cols-3 gap-8">
              <div className="text-center">
                <div className="w-16 h-16 bg-gradient-to-br from-blue-500 to-purple-600 rounded-full flex items-center justify-center mx-auto mb-4">
                  <Smartphone className="h-8 w-8 text-white" />
                </div>
                <h3 className="text-xl font-bold text-gray-900 mb-2">Mobile Optimized</h3>
                <p className="text-gray-600">Fully responsive design works perfectly on all mobile devices</p>
              </div>
              
              <div className="text-center">
                <div className="w-16 h-16 bg-gradient-to-br from-green-500 to-emerald-600 rounded-full flex items-center justify-center mx-auto mb-4">
                  <Monitor className="h-8 w-8 text-white" />
                </div>
                <h3 className="text-xl font-bold text-gray-900 mb-2">Desktop Ready</h3>
                <p className="text-gray-600">Full-featured desktop experience with advanced functionality</p>
              </div>
              
              <div className="text-center">
                <div className="w-16 h-16 bg-gradient-to-br from-orange-500 to-red-600 rounded-full flex items-center justify-center mx-auto mb-4">
                  <Globe className="h-8 w-8 text-white" />
                </div>
                <h3 className="text-xl font-bold text-gray-900 mb-2">Global Access</h3>
                <p className="text-gray-600">Multi-language support with RTL layouts for worldwide usage</p>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-20 bg-gradient-to-r from-primary to-purple-600">
        <div className="container mx-auto px-4 text-center">
          <div className="max-w-3xl mx-auto">
            <h2 className="text-4xl font-bold text-white mb-6">
              Experience All Features Today
            </h2>
            <p className="text-xl text-white/90 mb-8">
              Start your free 14-day trial and discover why thousands of teams choose SportsPro.
            </p>
            
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <Button 
                size="lg" 
                onClick={() => window.location.href = "/auth"}
                className="bg-white text-primary hover:bg-gray-50 text-lg px-8 py-4 shadow-xl"
              >
                Start Free Trial
                <ArrowRight className="ml-2 h-5 w-5" />
              </Button>
              <Button 
                size="lg" 
                variant="outline"
                className="border-2 border-white text-white hover:bg-white/10 text-lg px-8 py-4"
              >
                <PlayCircle className="mr-2 h-5 w-5" />
                Watch Demo
              </Button>
            </div>
            
            <p className="text-white/70 text-sm mt-4">
              No credit card required • 14-day free trial • Cancel anytime
            </p>
          </div>
        </div>
      </section>

      {/* Footer */}
      <footer className="bg-gray-900 text-white py-16">
        <div className="container mx-auto px-4">
          <div className="grid md:grid-cols-4 gap-8">
            <div className="space-y-4">
              <div className="flex items-center space-x-3">
                <div className="w-10 h-10 bg-gradient-to-br from-primary to-purple-600 rounded-lg flex items-center justify-center">
                  <Trophy className="h-6 w-6 text-white" />
                </div>
                <span className="text-xl font-bold">SportsPro</span>
              </div>
              <p className="text-gray-400">
                Professional sports management platform trusted by teams worldwide.
              </p>
            </div>
            
            <div>
              <h3 className="font-semibold mb-4">Product</h3>
              <ul className="space-y-2 text-gray-400">
                <li><a href="/services" className="hover:text-white transition-colors">Features</a></li>
                <li><a href="/pricing" className="hover:text-white transition-colors">Pricing</a></li>
                <li><a href="/security" className="hover:text-white transition-colors">Security</a></li>
                <li><a href="/integrations" className="hover:text-white transition-colors">Integrations</a></li>
              </ul>
            </div>
            
            <div>
              <h3 className="font-semibold mb-4">Support</h3>
              <ul className="space-y-2 text-gray-400">
                <li><a href="/docs" className="hover:text-white transition-colors">Documentation</a></li>
                <li><a href="/help" className="hover:text-white transition-colors">Help Center</a></li>
                <li><a href="/contact" className="hover:text-white transition-colors">Contact</a></li>
                <li><a href="/status" className="hover:text-white transition-colors">Status</a></li>
              </ul>
            </div>
            
            <div>
              <h3 className="font-semibold mb-4">Company</h3>
              <ul className="space-y-2 text-gray-400">
                <li><a href="/about" className="hover:text-white transition-colors">About</a></li>
                <li><a href="/careers" className="hover:text-white transition-colors">Careers</a></li>
                <li><a href="/press" className="hover:text-white transition-colors">Press</a></li>
                <li><a href="/partners" className="hover:text-white transition-colors">Partners</a></li>
              </ul>
            </div>
          </div>
          
          <div className="border-t border-gray-800 mt-12 pt-8 flex flex-col md:flex-row justify-between items-center">
            <p className="text-gray-400 text-sm">
              © 2025 SportsPro. All rights reserved.
            </p>
            <div className="flex space-x-6 mt-4 md:mt-0">
              <a href="/privacy" className="text-gray-400 hover:text-white text-sm transition-colors">Privacy</a>
              <a href="/terms" className="text-gray-400 hover:text-white text-sm transition-colors">Terms</a>
              <a href="/cookies" className="text-gray-400 hover:text-white text-sm transition-colors">Cookies</a>
            </div>
          </div>
        </div>
      </footer>
    </div>
  );
}