import { Button } from "@/components/ui/button";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Input } from "@/components/ui/input";
import { Textarea } from "@/components/ui/textarea";
import { Label } from "@/components/ui/label";
import { Trophy, MapPin, Phone, Mail, Clock, Menu, X, MessageSquare, Headphones, Users, Zap } from "lucide-react";
import { useState } from "react";
import SEOHead from "@/components/SEOHead";

export default function ContactPage() {
  const [mobileMenuOpen, setMobileMenuOpen] = useState(false);

  return (
    <div className="min-h-screen bg-gradient-to-br from-primary/5 via-background to-secondary/5">
      <SEOHead 
        title="Contact Us - SportsPro Sports Management Platform"
        description="Get in touch with SportsPro for sports management solutions. 24/7 support, custom integrations, and dedicated account managers for your sports organization."
        keywords="contact SportsPro, sports management support, customer service, sports platform help"
      />
      
      {/* Header */}
      <header className="border-b bg-white/80 backdrop-blur-sm">
        <div className="container mx-auto px-4 py-4">
          <div className="flex items-center justify-between">
            <div className="flex items-center space-x-3">
              <div className="w-10 h-10 bg-primary rounded-lg flex items-center justify-center">
                <Trophy className="h-6 w-6 text-white" />
              </div>
              <div>
                <h1 className="text-xl font-bold text-gray-900">SportsPro</h1>
                <p className="text-xs text-gray-500">Team Management</p>
              </div>
            </div>
            
            {/* Desktop Navigation */}
            <nav className="hidden md:flex items-center space-x-6">
              <a href="/" className="text-gray-600 hover:text-primary transition-colors">Home</a>
              <a href="/about" className="text-gray-600 hover:text-primary transition-colors">About</a>
              <a href="/services" className="text-gray-600 hover:text-primary transition-colors">Services</a>
              <a href="/contact" className="text-primary font-medium">Contact</a>
            </nav>
            
            <div className="flex items-center space-x-3">
              <Button onClick={() => window.location.href = "/auth"} size="lg" className="hidden sm:inline-flex">
                Get Started
              </Button>
              
              {/* Mobile menu button */}
              <Button
                variant="outline"
                size="sm"
                className="md:hidden"
                onClick={() => setMobileMenuOpen(!mobileMenuOpen)}
              >
                {mobileMenuOpen ? <X className="h-4 w-4" /> : <Menu className="h-4 w-4" />}
              </Button>
            </div>
          </div>
          
          {/* Mobile Navigation */}
          {mobileMenuOpen && (
            <div className="md:hidden mt-4 pb-4 border-t">
              <nav className="flex flex-col space-y-3 pt-4">
                <a href="/" className="text-gray-600 hover:text-primary transition-colors">Home</a>
                <a href="/about" className="text-gray-600 hover:text-primary transition-colors">About</a>
                <a href="/services" className="text-gray-600 hover:text-primary transition-colors">Services</a>
                <a href="/contact" className="text-primary font-medium">Contact</a>
                <Button onClick={() => window.location.href = "/auth"} size="sm" className="w-full mt-3">
                  Get Started
                </Button>
              </nav>
            </div>
          )}
        </div>
      </header>

      {/* Hero Section */}
      <section className="relative bg-gradient-to-r from-primary to-primary/80 text-white py-20 sm:py-24 lg:py-32">
        <div className="container mx-auto px-4 text-center">
          <h1 className="text-4xl sm:text-5xl lg:text-6xl font-bold mb-6">
            Get in <span className="text-yellow-300">Touch</span>
          </h1>
          <p className="text-xl sm:text-2xl text-primary-foreground/90 mb-8 max-w-3xl mx-auto">
            Ready to transform your sports organization? Our team is here to help you succeed.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Button 
              onClick={() => window.location.href = "mailto:sales@sportspro.com"}
              variant="secondary" 
              size="lg"
              className="text-lg px-8 py-4 h-auto"
            >
              <Mail className="mr-2 h-5 w-5" />
              Email Sales Team
            </Button>
            <Button 
              onClick={() => window.location.href = "tel:+15551234567"}
              variant="outline" 
              size="lg"
              className="text-lg px-8 py-4 h-auto bg-transparent border-white text-white hover:bg-white hover:text-primary"
            >
              <Phone className="mr-2 h-5 w-5" />
              Call Now
            </Button>
          </div>
        </div>
      </section>

      {/* Contact Methods */}
      <section className="py-16 sm:py-20 bg-white">
        <div className="container mx-auto px-4">
          <div className="text-center mb-12">
            <h2 className="text-3xl sm:text-4xl font-bold text-gray-900 mb-4">
              Multiple Ways to Connect
            </h2>
            <p className="text-lg text-gray-600 max-w-2xl mx-auto">
              Choose the method that works best for you. We're here to help.
            </p>
          </div>
          
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <Card className="text-center p-6 hover:shadow-lg transition-shadow">
              <div className="w-16 h-16 bg-primary/10 rounded-full flex items-center justify-center mx-auto mb-4">
                <MessageSquare className="h-8 w-8 text-primary" />
              </div>
              <h3 className="text-xl font-semibold mb-2">Live Chat</h3>
              <p className="text-gray-600 mb-4">Get instant help from our support team</p>
              <Button variant="outline" size="sm">Start Chat</Button>
            </Card>

            <Card className="text-center p-6 hover:shadow-lg transition-shadow">
              <div className="w-16 h-16 bg-secondary/10 rounded-full flex items-center justify-center mx-auto mb-4">
                <Phone className="h-8 w-8 text-secondary" />
              </div>
              <h3 className="text-xl font-semibold mb-2">Phone Support</h3>
              <p className="text-gray-600 mb-4">Talk directly with our experts</p>
              <Button variant="outline" size="sm">
                <a href="tel:+15551234567">Call Now</a>
              </Button>
            </Card>

            <Card className="text-center p-6 hover:shadow-lg transition-shadow">
              <div className="w-16 h-16 bg-success/10 rounded-full flex items-center justify-center mx-auto mb-4">
                <Mail className="h-8 w-8 text-success" />
              </div>
              <h3 className="text-xl font-semibold mb-2">Email</h3>
              <p className="text-gray-600 mb-4">Send us detailed questions</p>
              <Button variant="outline" size="sm">
                <a href="mailto:support@sportspro.com">Send Email</a>
              </Button>
            </Card>

            <Card className="text-center p-6 hover:shadow-lg transition-shadow">
              <div className="w-16 h-16 bg-warning/10 rounded-full flex items-center justify-center mx-auto mb-4">
                <Users className="h-8 w-8 text-warning" />
              </div>
              <h3 className="text-xl font-semibold mb-2">Schedule Demo</h3>
              <p className="text-gray-600 mb-4">See SportsPro in action</p>
              <Button variant="outline" size="sm">Book Demo</Button>
            </Card>
          </div>
        </div>
      </section>

      {/* Main Contact Section */}
      <section className="py-16 sm:py-20 bg-gray-50">
        <div className="container mx-auto px-4">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 max-w-6xl mx-auto">
            
            {/* Contact Form */}
            <div className="order-2 lg:order-1">
              <div className="bg-white p-8 rounded-xl shadow-lg">
                <h3 className="text-2xl font-bold text-gray-900 mb-6">Send us a Message</h3>
                <form className="space-y-6">
                  <div className="grid grid-cols-1 sm:grid-cols-2 gap-6">
                    <div>
                      <Label htmlFor="firstName">First Name *</Label>
                      <Input id="firstName" placeholder="Your first name" className="mt-2" />
                    </div>
                    <div>
                      <Label htmlFor="lastName">Last Name *</Label>
                      <Input id="lastName" placeholder="Your last name" className="mt-2" />
                    </div>
                  </div>

                  <div className="grid grid-cols-1 sm:grid-cols-2 gap-6">
                    <div>
                      <Label htmlFor="email">Email Address *</Label>
                      <Input id="email" type="email" placeholder="your.email@example.com" className="mt-2" />
                    </div>
                    <div>
                      <Label htmlFor="phone">Phone Number</Label>
                      <Input id="phone" placeholder="(555) 123-4567" className="mt-2" />
                    </div>
                  </div>

                  <div>
                    <Label htmlFor="organization">Organization/Team Name</Label>
                    <Input id="organization" placeholder="Your team or organization name" className="mt-2" />
                  </div>

                  <div>
                    <Label htmlFor="subject">Subject *</Label>
                    <Input id="subject" placeholder="What can we help you with?" className="mt-2" />
                  </div>

                  <div>
                    <Label htmlFor="message">Message *</Label>
                    <Textarea 
                      id="message" 
                      placeholder="Tell us more about your needs and how we can help..." 
                      className="mt-2 min-h-[120px]" 
                    />
                  </div>

                  <div className="flex items-center space-x-2">
                    <input type="checkbox" id="newsletter" className="rounded" />
                    <Label htmlFor="newsletter" className="text-sm text-gray-600">
                      I would like to receive updates and news about SportsPro
                    </Label>
                  </div>

                  <Button type="submit" size="lg" className="w-full">
                    <Mail className="mr-2 h-4 w-4" />
                    Send Message
                  </Button>
                </form>
              </div>
            </div>

            {/* Contact Information */}
            <div className="order-1 lg:order-2">
              <div className="space-y-6">
                <div>
                  <h3 className="text-2xl font-bold text-gray-900 mb-4">Get in Touch</h3>
                  <p className="text-gray-600 mb-8">
                    Our team is ready to help you transform your sports organization. 
                    Reach out using any of the methods below.
                  </p>
                </div>

                <div className="bg-white p-6 rounded-xl shadow-lg">
                  <div className="flex items-start mb-4">
                    <div className="w-12 h-12 bg-primary/10 rounded-lg flex items-center justify-center mr-4 flex-shrink-0">
                      <MapPin className="h-6 w-6 text-primary" />
                    </div>
                    <div>
                      <h4 className="text-lg font-semibold text-gray-900 mb-2">Address</h4>
                      <p className="text-gray-600 leading-relaxed">
                        SportsPro Headquarters<br />
                        123 Innovation Drive<br />
                        Tech District, Suite 400<br />
                        New York, NY 10001<br />
                        United States
                      </p>
                    </div>
                  </div>
                </div>

                <div className="bg-white p-6 rounded-xl shadow-lg">
                  <div className="flex items-start mb-4">
                    <div className="w-12 h-12 bg-secondary/10 rounded-lg flex items-center justify-center mr-4 flex-shrink-0">
                      <Phone className="h-6 w-6 text-secondary" />
                    </div>
                    <div>
                      <h4 className="text-lg font-semibold text-gray-900 mb-2">Phone</h4>
                      <div className="text-gray-600 space-y-1">
                        <p>Main: <a href="tel:+15551234567" className="hover:text-primary transition-colors">+1 (555) 123-4567</a></p>
                        <p>Support: <a href="tel:+15551234568" className="hover:text-primary transition-colors">+1 (555) 123-4568</a></p>
                        <p>Sales: <a href="tel:+15551234569" className="hover:text-primary transition-colors">+1 (555) 123-4569</a></p>
                      </div>
                    </div>
                  </div>
                </div>

                <div className="bg-white p-6 rounded-xl shadow-lg">
                  <div className="flex items-start mb-4">
                    <div className="w-12 h-12 bg-success/10 rounded-lg flex items-center justify-center mr-4 flex-shrink-0">
                      <Mail className="h-6 w-6 text-success" />
                    </div>
                    <div>
                      <h4 className="text-lg font-semibold text-gray-900 mb-2">Email</h4>
                      <div className="text-gray-600 space-y-1">
                        <p>General: <a href="mailto:info@sportspro.com" className="hover:text-primary transition-colors">info@sportspro.com</a></p>
                        <p>Support: <a href="mailto:support@sportspro.com" className="hover:text-primary transition-colors">support@sportspro.com</a></p>
                        <p>Sales: <a href="mailto:sales@sportspro.com" className="hover:text-primary transition-colors">sales@sportspro.com</a></p>
                      </div>
                    </div>
                  </div>
                </div>

                <div className="bg-white p-6 rounded-xl shadow-lg">
                  <div className="flex items-start mb-4">
                    <div className="w-12 h-12 bg-warning/10 rounded-lg flex items-center justify-center mr-4 flex-shrink-0">
                      <Clock className="h-6 w-6 text-warning" />
                    </div>
                    <div>
                      <h4 className="text-lg font-semibold text-gray-900 mb-2">Business Hours</h4>
                      <div className="text-gray-600 space-y-1">
                        <p>Monday - Friday: 8:00 AM - 6:00 PM EST</p>
                        <p>Saturday: 9:00 AM - 2:00 PM EST</p>
                        <p>Sunday: Closed</p>
                        <p className="text-primary font-medium mt-2">24/7 Emergency Support Available</p>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* FAQ Section */}
      <section className="py-16 sm:py-20 bg-white">
        <div className="container mx-auto px-4">
          <div className="text-center mb-12">
            <h3 className="text-3xl font-bold text-gray-900 mb-4">Frequently Asked Questions</h3>
            <p className="text-lg text-gray-600 max-w-3xl mx-auto">
              Find answers to common questions about SportsPro
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 gap-8 max-w-4xl mx-auto">
            <Card className="hover:shadow-lg transition-shadow">
              <CardHeader>
                <CardTitle className="text-lg">How quickly can we get started?</CardTitle>
              </CardHeader>
              <CardContent>
                <CardDescription>
                  Most organizations can be up and running within 24-48 hours. Our onboarding team will guide you through the setup process.
                </CardDescription>
              </CardContent>
            </Card>

            <Card className="hover:shadow-lg transition-shadow">
              <CardHeader>
                <CardTitle className="text-lg">Is my data secure?</CardTitle>
              </CardHeader>
              <CardContent>
                <CardDescription>
                  Yes, we use enterprise-grade security with encrypted data storage, secure access controls, and regular security audits.
                </CardDescription>
              </CardContent>
            </Card>

            <Card className="hover:shadow-lg transition-shadow">
              <CardHeader>
                <CardTitle className="text-lg">Do you offer custom integrations?</CardTitle>
              </CardHeader>
              <CardContent>
                <CardDescription>
                  Our Enterprise plan includes custom integrations with your existing systems. Contact our sales team for more details.
                </CardDescription>
              </CardContent>
            </Card>

            <Card className="hover:shadow-lg transition-shadow">
              <CardHeader>
                <CardTitle className="text-lg">What support do you provide?</CardTitle>
              </CardHeader>
              <CardContent>
                <CardDescription>
                  We offer 24/7 support with dedicated account managers for Enterprise clients and priority support for Professional plans.
                </CardDescription>
              </CardContent>
            </Card>
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="bg-primary text-white py-16 sm:py-20">
        <div className="container mx-auto px-4 text-center">
          <h3 className="text-3xl font-bold mb-4">
            Ready to Get Started?
          </h3>
          <p className="text-xl mb-8 text-primary-foreground/90 max-w-2xl mx-auto">
            Join thousands of sports organizations using SportsPro to transform their operations
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Button 
              onClick={() => window.location.href = "/auth"}
              variant="secondary" 
              size="lg"
              className="text-lg px-8 py-4 h-auto"
            >
              Start Free Trial
            </Button>
            <Button 
              onClick={() => window.location.href = "mailto:sales@sportspro.com"}
              variant="outline" 
              size="lg"
              className="text-lg px-8 py-4 h-auto bg-transparent border-white text-white hover:bg-white hover:text-primary"
            >
              Schedule Demo
            </Button>
          </div>
        </div>
      </section>

      {/* Footer */}
      <footer className="bg-white border-t py-8">
        <div className="container mx-auto px-4">
          <div className="flex flex-col sm:flex-row items-center justify-between space-y-4 sm:space-y-0">
            <div className="flex items-center space-x-3">
              <div className="w-8 h-8 bg-primary rounded-lg flex items-center justify-center">
                <Trophy className="h-5 w-5 text-white" />
              </div>
              <span className="font-bold text-gray-900">SportsPro</span>
            </div>
            <p className="text-gray-500 text-sm text-center sm:text-right">
              © 2024 SportsPro. Professional sports management platform.
            </p>
          </div>
        </div>
      </footer>
    </div>
  );
}