import { Button } from "@/components/ui/button";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Badge } from "@/components/ui/badge";
import { 
  Trophy, Users, Target, Zap, Shield, Clock, Heart, Menu, X, 
  Video, Brain, Fingerprint, BarChart3, Star, Award, Globe,
  CheckCircle, Sparkles, Rocket, ArrowRight, UserPlus
} from "lucide-react";
import { useState } from "react";

export default function AboutPage() {
  const [mobileMenuOpen, setMobileMenuOpen] = useState(false);

  return (
    <div className="min-h-screen bg-gradient-to-br from-slate-50 via-white to-slate-50">
      {/* Header */}
      <header className="sticky top-0 z-50 border-b bg-white/80 backdrop-blur-lg shadow-sm">
        <div className="container mx-auto px-4 py-4">
          <div className="flex items-center justify-between">
            <div className="flex items-center space-x-3">
              <div className="w-12 h-12 bg-gradient-to-br from-primary to-purple-600 rounded-xl flex items-center justify-center shadow-lg">
                <Trophy className="h-7 w-7 text-white" />
              </div>
              <div>
                <h1 className="text-2xl font-bold bg-gradient-to-r from-gray-900 to-gray-700 bg-clip-text text-transparent">
                  SportsPro
                </h1>
                <p className="text-xs text-gray-500 font-medium">Professional Sports Management</p>
              </div>
            </div>
            
            {/* Desktop Navigation */}
            <nav className="hidden lg:flex items-center space-x-8">
              <a href="/" className="text-gray-600 hover:text-primary transition-colors font-medium">Home</a>
              <a href="/about" className="text-primary font-semibold">About</a>
              <a href="/services" className="text-gray-600 hover:text-primary transition-colors font-medium">Features</a>
              <a href="/contact" className="text-gray-600 hover:text-primary transition-colors font-medium">Contact</a>
              <div className="h-6 w-px bg-gray-200"></div>
              <Button variant="outline" className="font-medium">Sign In</Button>
            </nav>
            
            <div className="flex items-center space-x-3">
              <Button 
                onClick={() => window.location.href = "/auth"} 
                size="lg" 
                className="hidden sm:inline-flex bg-gradient-to-r from-primary to-purple-600 hover:from-primary/90 hover:to-purple-600/90 font-semibold shadow-lg"
              >
                Get Started Free
                <ArrowRight className="ml-2 h-4 w-4" />
              </Button>
              
              {/* Mobile menu button */}
              <Button
                variant="outline"
                size="sm"
                className="lg:hidden"
                onClick={() => setMobileMenuOpen(!mobileMenuOpen)}
              >
                {mobileMenuOpen ? <X className="h-4 w-4" /> : <Menu className="h-4 w-4" />}
              </Button>
            </div>
          </div>
          
          {/* Mobile Navigation */}
          {mobileMenuOpen && (
            <div className="lg:hidden mt-4 pt-4 border-t bg-white rounded-lg shadow-lg">
              <nav className="flex flex-col space-y-3 p-4">
                <a href="/" className="text-gray-600 hover:text-primary transition-colors py-2">Home</a>
                <a href="/about" className="text-primary font-semibold py-2">About</a>
                <a href="/services" className="text-gray-600 hover:text-primary transition-colors py-2">Features</a>
                <a href="/contact" className="text-gray-600 hover:text-primary transition-colors py-2">Contact</a>
                <div className="pt-2">
                  <Button onClick={() => window.location.href = "/auth"} className="w-full">
                    Get Started Free
                  </Button>
                </div>
              </nav>
            </div>
          )}
        </div>
      </header>

      {/* Hero Section */}
      <section className="py-20 lg:py-32">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto text-center">
            <Badge className="bg-gradient-to-r from-primary to-purple-600 text-white border-0 shadow-lg mb-6">
              <Sparkles className="h-3 w-3 mr-1" />
              About SportsPro
            </Badge>
            <h1 className="text-5xl lg:text-6xl font-bold leading-tight mb-6">
              <span className="bg-gradient-to-r from-gray-900 via-primary to-purple-600 bg-clip-text text-transparent">
                Revolutionizing
              </span>
              <br />
              <span className="text-gray-900">Sports Management</span>
            </h1>
            <p className="text-xl text-gray-600 leading-relaxed max-w-3xl mx-auto mb-8">
              We're on a mission to transform how sports organizations manage their teams, 
              analyze performance, and engage with players through cutting-edge AI technology 
              and comprehensive management tools.
            </p>
            
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <Button 
                size="lg" 
                onClick={() => window.location.href = "/auth"}
                className="bg-gradient-to-r from-primary to-purple-600 hover:from-primary/90 hover:to-purple-600/90 text-lg px-8 py-4 shadow-xl"
              >
                Start Your Journey
                <Rocket className="ml-2 h-5 w-5" />
              </Button>
              <Button 
                size="lg" 
                variant="outline" 
                className="text-lg px-8 py-4 border-2 hover:bg-gray-50"
              >
                Learn More
                <ArrowRight className="ml-2 h-5 w-5" />
              </Button>
            </div>
          </div>
        </div>
      </section>

      {/* Mission Section */}
      <section className="py-20 bg-gray-50">
        <div className="container mx-auto px-4">
          <div className="max-w-6xl mx-auto">
            <div className="text-center mb-16">
              <h2 className="text-4xl font-bold text-gray-900 mb-4">Our Mission</h2>
              <p className="text-xl text-gray-600 max-w-3xl mx-auto">
                To empower sports organizations worldwide with intelligent technology that simplifies management, 
                enhances performance, and creates exceptional experiences for athletes and fans alike.
              </p>
            </div>
            
            <div className="grid md:grid-cols-3 gap-8">
              <Card className="text-center border-0 shadow-lg hover:shadow-xl transition-all">
                <CardContent className="p-8">
                  <div className="w-16 h-16 bg-gradient-to-br from-blue-500 to-purple-600 rounded-full flex items-center justify-center mx-auto mb-6">
                    <Brain className="h-8 w-8 text-white" />
                  </div>
                  <h3 className="text-xl font-bold text-gray-900 mb-4">AI-Powered Innovation</h3>
                  <p className="text-gray-600">
                    Leveraging cutting-edge artificial intelligence to automate complex tasks and provide 
                    intelligent insights that drive better decision-making.
                  </p>
                </CardContent>
              </Card>
              
              <Card className="text-center border-0 shadow-lg hover:shadow-xl transition-all">
                <CardContent className="p-8">
                  <div className="w-16 h-16 bg-gradient-to-br from-green-500 to-emerald-600 rounded-full flex items-center justify-center mx-auto mb-6">
                    <Shield className="h-8 w-8 text-white" />
                  </div>
                  <h3 className="text-xl font-bold text-gray-900 mb-4">Security First</h3>
                  <p className="text-gray-600">
                    Enterprise-grade security with advanced biometric authentication and comprehensive 
                    privacy controls to protect sensitive athlete data.
                  </p>
                </CardContent>
              </Card>
              
              <Card className="text-center border-0 shadow-lg hover:shadow-xl transition-all">
                <CardContent className="p-8">
                  <div className="w-16 h-16 bg-gradient-to-br from-orange-500 to-red-600 rounded-full flex items-center justify-center mx-auto mb-6">
                    <Globe className="h-8 w-8 text-white" />
                  </div>
                  <h3 className="text-xl font-bold text-gray-900 mb-4">Global Impact</h3>
                  <p className="text-gray-600">
                    Supporting sports organizations worldwide with multi-language interfaces, 
                    global payment gateways, and culturally adaptive features.
                  </p>
                </CardContent>
              </Card>
            </div>
          </div>
        </div>
      </section>

      {/* Innovation Timeline */}
      <section className="py-20">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto">
            <div className="text-center mb-16">
              <h2 className="text-4xl font-bold text-gray-900 mb-4">Innovation Journey</h2>
              <p className="text-xl text-gray-600">
                See how SportsPro has evolved to become the most advanced sports management platform
              </p>
            </div>
            
            <div className="space-y-8">
              {[
                {
                  date: "2025",
                  title: "AI Video Highlights",
                  description: "Revolutionary AI-powered video analysis automatically generates professional highlight reels",
                  icon: <Video className="h-6 w-6 text-purple-600" />,
                  color: "from-purple-500 to-pink-500"
                },
                {
                  date: "2024",
                  title: "Biometric Security",
                  description: "Advanced facial recognition and comprehensive privacy controls for enterprise security",
                  icon: <Fingerprint className="h-6 w-6 text-green-600" />,
                  color: "from-green-500 to-emerald-500"
                },
                {
                  date: "2024",
                  title: "Smart Onboarding",
                  description: "AI-powered setup recommendations based on sport type and team objectives",
                  icon: <Brain className="h-6 w-6 text-blue-600" />,
                  color: "from-blue-500 to-cyan-500"
                },
                {
                  date: "2023",
                  title: "Multi-Sport Platform",
                  description: "Comprehensive support for 10+ sports with specialized features for each discipline",
                  icon: <Trophy className="h-6 w-6 text-orange-600" />,
                  color: "from-orange-500 to-red-500"
                }
              ].map((milestone, index) => (
                <div key={index} className="relative">
                  <div className="flex items-center space-x-6">
                    <div className={`w-16 h-16 bg-gradient-to-br ${milestone.color} rounded-full flex items-center justify-center shadow-lg`}>
                      {milestone.icon}
                    </div>
                    <div className="flex-1">
                      <div className="flex items-center space-x-3 mb-2">
                        <Badge variant="outline" className="text-xs">{milestone.date}</Badge>
                        <h3 className="text-xl font-bold text-gray-900">{milestone.title}</h3>
                      </div>
                      <p className="text-gray-600">{milestone.description}</p>
                    </div>
                  </div>
                  {index < 3 && (
                    <div className="absolute left-8 top-16 w-px h-8 bg-gray-200"></div>
                  )}
                </div>
              ))}
            </div>
          </div>
        </div>
      </section>

      {/* Values Section */}
      <section className="py-20 bg-gray-50">
        <div className="container mx-auto px-4">
          <div className="max-w-6xl mx-auto">
            <div className="text-center mb-16">
              <h2 className="text-4xl font-bold text-gray-900 mb-4">Our Values</h2>
              <p className="text-xl text-gray-600">
                The principles that guide everything we do
              </p>
            </div>
            
            <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-6">
              {[
                {
                  icon: <Target className="h-8 w-8 text-blue-600" />,
                  title: "Excellence",
                  description: "We strive for perfection in every feature and interaction"
                },
                {
                  icon: <Heart className="h-8 w-8 text-red-600" />,
                  title: "Passion",
                  description: "Driven by love for sports and technology innovation"
                },
                {
                  icon: <Users className="h-8 w-8 text-green-600" />,
                  title: "Community",
                  description: "Building connections between athletes, coaches, and fans"
                },
                {
                  icon: <Zap className="h-8 w-8 text-yellow-600" />,
                  title: "Innovation",
                  description: "Constantly pushing boundaries with cutting-edge technology"
                }
              ].map((value, index) => (
                <Card key={index} className="text-center border-0 shadow-lg hover:shadow-xl transition-all group">
                  <CardContent className="p-6">
                    <div className="w-16 h-16 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4 group-hover:scale-110 transition-transform">
                      {value.icon}
                    </div>
                    <h3 className="text-lg font-bold text-gray-900 mb-2">{value.title}</h3>
                    <p className="text-gray-600 text-sm">{value.description}</p>
                  </CardContent>
                </Card>
              ))}
            </div>
          </div>
        </div>
      </section>

      {/* Stats Section */}
      <section className="py-20">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto text-center">
            <h2 className="text-4xl font-bold text-gray-900 mb-4">Trusted Worldwide</h2>
            <p className="text-xl text-gray-600 mb-12">
              SportsPro powers sports organizations across the globe
            </p>
            
            <div className="grid md:grid-cols-4 gap-8">
              {[
                { stat: "10,000+", label: "Active Teams", icon: <Users className="h-8 w-8" /> },
                { stat: "500K+", label: "Players Managed", icon: <UserPlus className="h-8 w-8" /> },
                { stat: "50+", label: "Countries", icon: <Globe className="h-8 w-8" /> },
                { stat: "99.9%", label: "Uptime", icon: <CheckCircle className="h-8 w-8" /> }
              ].map((item, index) => (
                <div key={index} className="text-center">
                  <div className="w-16 h-16 bg-gradient-to-br from-primary to-purple-600 rounded-full flex items-center justify-center mx-auto mb-4 text-white">
                    {item.icon}
                  </div>
                  <div className="text-4xl font-bold text-primary mb-2">{item.stat}</div>
                  <div className="text-gray-600">{item.label}</div>
                </div>
              ))}
            </div>
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-20 bg-gradient-to-r from-primary to-purple-600">
        <div className="container mx-auto px-4 text-center">
          <div className="max-w-3xl mx-auto">
            <h2 className="text-4xl font-bold text-white mb-6">
              Ready to Join the Revolution?
            </h2>
            <p className="text-xl text-white/90 mb-8">
              Experience the future of sports management with SportsPro's AI-powered platform.
            </p>
            
            <Button 
              size="lg" 
              onClick={() => window.location.href = "/auth"}
              className="bg-white text-primary hover:bg-gray-50 text-lg px-8 py-4 shadow-xl"
            >
              Start Free Trial
              <ArrowRight className="ml-2 h-5 w-5" />
            </Button>
            
            <p className="text-white/70 text-sm mt-4">
              No credit card required • 14-day free trial • Cancel anytime
            </p>
          </div>
        </div>
      </section>

      {/* Footer */}
      <footer className="bg-gray-900 text-white py-16">
        <div className="container mx-auto px-4">
          <div className="grid md:grid-cols-4 gap-8">
            <div className="space-y-4">
              <div className="flex items-center space-x-3">
                <div className="w-10 h-10 bg-gradient-to-br from-primary to-purple-600 rounded-lg flex items-center justify-center">
                  <Trophy className="h-6 w-6 text-white" />
                </div>
                <span className="text-xl font-bold">SportsPro</span>
              </div>
              <p className="text-gray-400">
                Professional sports management platform trusted by teams worldwide.
              </p>
            </div>
            
            <div>
              <h3 className="font-semibold mb-4">Product</h3>
              <ul className="space-y-2 text-gray-400">
                <li><a href="/services" className="hover:text-white transition-colors">Features</a></li>
                <li><a href="/pricing" className="hover:text-white transition-colors">Pricing</a></li>
                <li><a href="/security" className="hover:text-white transition-colors">Security</a></li>
                <li><a href="/integrations" className="hover:text-white transition-colors">Integrations</a></li>
              </ul>
            </div>
            
            <div>
              <h3 className="font-semibold mb-4">Support</h3>
              <ul className="space-y-2 text-gray-400">
                <li><a href="/docs" className="hover:text-white transition-colors">Documentation</a></li>
                <li><a href="/help" className="hover:text-white transition-colors">Help Center</a></li>
                <li><a href="/contact" className="hover:text-white transition-colors">Contact</a></li>
                <li><a href="/status" className="hover:text-white transition-colors">Status</a></li>
              </ul>
            </div>
            
            <div>
              <h3 className="font-semibold mb-4">Company</h3>
              <ul className="space-y-2 text-gray-400">
                <li><a href="/about" className="hover:text-white transition-colors">About</a></li>
                <li><a href="/careers" className="hover:text-white transition-colors">Careers</a></li>
                <li><a href="/press" className="hover:text-white transition-colors">Press</a></li>
                <li><a href="/partners" className="hover:text-white transition-colors">Partners</a></li>
              </ul>
            </div>
          </div>
          
          <div className="border-t border-gray-800 mt-12 pt-8 flex flex-col md:flex-row justify-between items-center">
            <p className="text-gray-400 text-sm">
              © 2025 SportsPro. All rights reserved.
            </p>
            <div className="flex space-x-6 mt-4 md:mt-0">
              <a href="/privacy" className="text-gray-400 hover:text-white text-sm transition-colors">Privacy</a>
              <a href="/terms" className="text-gray-400 hover:text-white text-sm transition-colors">Terms</a>
              <a href="/cookies" className="text-gray-400 hover:text-white text-sm transition-colors">Cookies</a>
            </div>
          </div>
        </div>
      </footer>
    </div>
  );
}