import { createRoot } from "react-dom/client";
import { ThemeProvider } from "@/components/theme-provider";
import { AccessibilityProvider } from "@/components/accessibility-provider";
import App from "./App";
import "./index.css";

createRoot(document.getElementById("root")!).render(
  <ThemeProvider defaultTheme="light" storageKey="rugby-app-theme">
    <AccessibilityProvider storageKey="rugby-app-accessibility">
      <App />
    </AccessibilityProvider>
  </ThemeProvider>
);
