import { 
  Trophy, 
  Shield, 
  Target,
  Zap,
  Wind,
  Circle,
  Disc,
  Hexagon,
  type LucideIcon
} from "lucide-react";
import type { SportType } from "@shared/sports";

export function getSportIcon(sport: SportType): LucideIcon {
  const iconMap: Record<SportType, LucideIcon> = {
    football: Hexagon,
    rugby: Shield,
    cricket: Target,
    baseball: Circle,
    basketball: Circle,
    hockey: Disc,
    netball: Target,
    soccer: Hexagon,
    badminton: Wind,
    volleyball: Zap,
  };
  
  return iconMap[sport] || Trophy;
}

export function getSportIconColor(sport: SportType): { bg: string; text: string; darkBg: string; darkText: string } {
  const colorMap: Record<SportType, { bg: string; text: string; darkBg: string; darkText: string }> = {
    football: { 
      bg: "bg-orange-100", 
      text: "text-orange-600", 
      darkBg: "dark:bg-orange-900/30", 
      darkText: "dark:text-orange-400" 
    },
    rugby: { 
      bg: "bg-green-100", 
      text: "text-green-600", 
      darkBg: "dark:bg-green-900/30", 
      darkText: "dark:text-green-400" 
    },
    cricket: { 
      bg: "bg-yellow-100", 
      text: "text-yellow-600", 
      darkBg: "dark:bg-yellow-900/30", 
      darkText: "dark:text-yellow-400" 
    },
    baseball: { 
      bg: "bg-red-100", 
      text: "text-red-600", 
      darkBg: "dark:bg-red-900/30", 
      darkText: "dark:text-red-400" 
    },
    basketball: { 
      bg: "bg-orange-100", 
      text: "text-orange-600", 
      darkBg: "dark:bg-orange-900/30", 
      darkText: "dark:text-orange-400" 
    },
    hockey: { 
      bg: "bg-cyan-100", 
      text: "text-cyan-600", 
      darkBg: "dark:bg-cyan-900/30", 
      darkText: "dark:text-cyan-400" 
    },
    netball: { 
      bg: "bg-pink-100", 
      text: "text-pink-600", 
      darkBg: "dark:bg-pink-900/30", 
      darkText: "dark:text-pink-400" 
    },
    soccer: { 
      bg: "bg-blue-100", 
      text: "text-blue-600", 
      darkBg: "dark:bg-blue-900/30", 
      darkText: "dark:text-blue-400" 
    },
    badminton: { 
      bg: "bg-purple-100", 
      text: "text-purple-600", 
      darkBg: "dark:bg-purple-900/30", 
      darkText: "dark:text-purple-400" 
    },
    volleyball: { 
      bg: "bg-indigo-100", 
      text: "text-indigo-600", 
      darkBg: "dark:bg-indigo-900/30", 
      darkText: "dark:text-indigo-400" 
    },
  };
  
  return colorMap[sport] || { 
    bg: "bg-blue-100", 
    text: "text-blue-600", 
    darkBg: "dark:bg-blue-900/30", 
    darkText: "dark:text-blue-400" 
  };
}
