import { createContext, useContext } from 'react';

export type Language = 'en' | 'es' | 'fr' | 'de' | 'it' | 'pt' | 'ru' | 'zh' | 'ja' | 'ar';

export const languages: Record<Language, string> = {
  en: 'English',
  es: 'Español',
  fr: 'Français',
  de: 'Deutsch',
  it: 'Italiano',
  pt: 'Português',
  ru: 'Русский',
  zh: '中文',
  ja: '日本語',
  ar: 'العربية'
};

export const translations = {
  en: {
    // Navigation
    dashboard: 'Dashboard',
    teams: 'Teams',
    players: 'Players',
    coaches: 'Coaches',
    analytics: 'Analytics',
    calendar: 'Calendar',
    settings: 'Settings',
    
    // Team Management
    teamManagement: 'Team Management',
    addTeam: 'Add Team',
    editTeam: 'Edit Team',
    deleteTeam: 'Delete Team',
    teamName: 'Team Name',
    sport: 'Sport',
    status: 'Status',
    description: 'Description',
    
    // Coach Management
    coachManagement: 'Coach Management',
    addCoach: 'Add Coach',
    editCoach: 'Edit Coach',
    deleteCoach: 'Delete Coach',
    firstName: 'First Name',
    lastName: 'Last Name',
    email: 'Email',
    phone: 'Phone',
    experience: 'Experience',
    specialization: 'Specialization',
    
    // Profile Management
    profile: 'Profile',
    roleManagement: 'Role Management',
    clubRoles: 'Club Roles',
    permissions: 'Permissions',
    
    // Common
    save: 'Save',
    cancel: 'Cancel',
    delete: 'Delete',
    edit: 'Edit',
    add: 'Add',
    create: 'Create',
    update: 'Update',
    search: 'Search',
    loading: 'Loading...',
    success: 'Success',
    error: 'Error',
    confirmDelete: 'Are you sure you want to delete this item?',
    
    // Roles
    superAdmin: 'Super Admin',
    admin: 'Admin',
    coach: 'Coach',
    player: 'Player',
    manager: 'Manager',
    viewer: 'Viewer'
  },
  es: {
    // Navigation
    dashboard: 'Panel de Control',
    teams: 'Equipos',
    players: 'Jugadores',
    coaches: 'Entrenadores',
    analytics: 'Análisis',
    calendar: 'Calendario',
    settings: 'Configuración',
    
    // Team Management
    teamManagement: 'Gestión de Equipos',
    addTeam: 'Agregar Equipo',
    editTeam: 'Editar Equipo',
    deleteTeam: 'Eliminar Equipo',
    teamName: 'Nombre del Equipo',
    sport: 'Deporte',
    status: 'Estado',
    description: 'Descripción',
    
    // Coach Management
    coachManagement: 'Gestión de Entrenadores',
    addCoach: 'Agregar Entrenador',
    editCoach: 'Editar Entrenador',
    deleteCoach: 'Eliminar Entrenador',
    firstName: 'Nombre',
    lastName: 'Apellido',
    email: 'Correo Electrónico',
    phone: 'Teléfono',
    experience: 'Experiencia',
    specialization: 'Especialización',
    
    // Profile Management
    profile: 'Perfil',
    roleManagement: 'Gestión de Roles',
    clubRoles: 'Roles del Club',
    permissions: 'Permisos',
    
    // Common
    save: 'Guardar',
    cancel: 'Cancelar',
    delete: 'Eliminar',
    edit: 'Editar',
    add: 'Agregar',
    create: 'Crear',
    update: 'Actualizar',
    search: 'Buscar',
    loading: 'Cargando...',
    success: 'Éxito',
    error: 'Error',
    confirmDelete: '¿Está seguro de que desea eliminar este elemento?',
    
    // Roles
    superAdmin: 'Super Administrador',
    admin: 'Administrador',
    coach: 'Entrenador',
    player: 'Jugador',
    manager: 'Gerente',
    viewer: 'Observador'
  },
  fr: {
    // Navigation
    dashboard: 'Tableau de Bord',
    teams: 'Équipes',
    players: 'Joueurs',
    coaches: 'Entraîneurs',
    analytics: 'Analyses',
    calendar: 'Calendrier',
    settings: 'Paramètres',
    
    // Team Management
    teamManagement: 'Gestion des Équipes',
    addTeam: 'Ajouter une Équipe',
    editTeam: 'Modifier l\'Équipe',
    deleteTeam: 'Supprimer l\'Équipe',
    teamName: 'Nom de l\'Équipe',
    sport: 'Sport',
    status: 'Statut',
    description: 'Description',
    
    // Coach Management
    coachManagement: 'Gestion des Entraîneurs',
    addCoach: 'Ajouter un Entraîneur',
    editCoach: 'Modifier l\'Entraîneur',
    deleteCoach: 'Supprimer l\'Entraîneur',
    firstName: 'Prénom',
    lastName: 'Nom de Famille',
    email: 'E-mail',
    phone: 'Téléphone',
    experience: 'Expérience',
    specialization: 'Spécialisation',
    
    // Profile Management
    profile: 'Profil',
    roleManagement: 'Gestion des Rôles',
    clubRoles: 'Rôles du Club',
    permissions: 'Permissions',
    
    // Common
    save: 'Enregistrer',
    cancel: 'Annuler',
    delete: 'Supprimer',
    edit: 'Modifier',
    add: 'Ajouter',
    create: 'Créer',
    update: 'Mettre à Jour',
    search: 'Rechercher',
    loading: 'Chargement...',
    success: 'Succès',
    error: 'Erreur',
    confirmDelete: 'Êtes-vous sûr de vouloir supprimer cet élément?',
    
    // Roles
    superAdmin: 'Super Administrateur',
    admin: 'Administrateur',
    coach: 'Entraîneur',
    player: 'Joueur',
    manager: 'Gestionnaire',
    viewer: 'Observateur'
  },
  de: {
    // Navigation
    dashboard: 'Dashboard',
    teams: 'Teams',
    players: 'Spieler',
    coaches: 'Trainer',
    analytics: 'Analytics',
    calendar: 'Kalender',
    settings: 'Einstellungen',
    
    // Team Management
    teamManagement: 'Team-Verwaltung',
    addTeam: 'Team hinzufügen',
    editTeam: 'Team bearbeiten',
    deleteTeam: 'Team löschen',
    teamName: 'Team-Name',
    sport: 'Sport',
    status: 'Status',
    description: 'Beschreibung',
    
    // Coach Management
    coachManagement: 'Trainer-Verwaltung',
    addCoach: 'Trainer hinzufügen',
    editCoach: 'Trainer bearbeiten',
    deleteCoach: 'Trainer löschen',
    firstName: 'Vorname',
    lastName: 'Nachname',
    email: 'E-Mail',
    phone: 'Telefon',
    experience: 'Erfahrung',
    specialization: 'Spezialisierung',
    
    // Profile Management
    profile: 'Profil',
    roleManagement: 'Rollen-Verwaltung',
    clubRoles: 'Vereinsrollen',
    permissions: 'Berechtigungen',
    
    // Common
    save: 'Speichern',
    cancel: 'Abbrechen',
    delete: 'Löschen',
    edit: 'Bearbeiten',
    add: 'Hinzufügen',
    create: 'Erstellen',
    update: 'Aktualisieren',
    search: 'Suchen',
    loading: 'Laden...',
    success: 'Erfolg',
    error: 'Fehler',
    confirmDelete: 'Sind Sie sicher, dass Sie dieses Element löschen möchten?',
    
    // Roles
    superAdmin: 'Super Administrator',
    admin: 'Administrator',
    coach: 'Trainer',
    player: 'Spieler',
    manager: 'Manager',
    viewer: 'Betrachter'
  },
  it: {
    // Navigation
    dashboard: 'Dashboard',
    teams: 'Squadre',
    players: 'Giocatori',
    coaches: 'Allenatori',
    analytics: 'Analytics',
    calendar: 'Calendario',
    settings: 'Impostazioni',
    
    // Team Management
    teamManagement: 'Gestione Squadre',
    addTeam: 'Aggiungi Squadra',
    editTeam: 'Modifica Squadra',
    deleteTeam: 'Elimina Squadra',
    teamName: 'Nome Squadra',
    sport: 'Sport',
    status: 'Stato',
    description: 'Descrizione',
    
    // Coach Management
    coachManagement: 'Gestione Allenatori',
    addCoach: 'Aggiungi Allenatore',
    editCoach: 'Modifica Allenatore',
    deleteCoach: 'Elimina Allenatore',
    firstName: 'Nome',
    lastName: 'Cognome',
    email: 'Email',
    phone: 'Telefono',
    experience: 'Esperienza',
    specialization: 'Specializzazione',
    
    // Profile Management
    profile: 'Profilo',
    roleManagement: 'Gestione Ruoli',
    clubRoles: 'Ruoli del Club',
    permissions: 'Permessi',
    
    // Common
    save: 'Salva',
    cancel: 'Annulla',
    delete: 'Elimina',
    edit: 'Modifica',
    add: 'Aggiungi',
    create: 'Crea',
    update: 'Aggiorna',
    search: 'Cerca',
    loading: 'Caricamento...',
    success: 'Successo',
    error: 'Errore',
    confirmDelete: 'Sei sicuro di voler eliminare questo elemento?',
    
    // Roles
    superAdmin: 'Super Amministratore',
    admin: 'Amministratore',
    coach: 'Allenatore',
    player: 'Giocatore',
    manager: 'Manager',
    viewer: 'Visualizzatore'
  },
  pt: {
    // Navigation
    dashboard: 'Painel',
    teams: 'Equipes',
    players: 'Jogadores',
    coaches: 'Treinadores',
    analytics: 'Análises',
    calendar: 'Calendário',
    settings: 'Configurações',
    
    // Team Management
    teamManagement: 'Gestão de Equipes',
    addTeam: 'Adicionar Equipe',
    editTeam: 'Editar Equipe',
    deleteTeam: 'Excluir Equipe',
    teamName: 'Nome da Equipe',
    sport: 'Esporte',
    status: 'Status',
    description: 'Descrição',
    
    // Coach Management
    coachManagement: 'Gestão de Treinadores',
    addCoach: 'Adicionar Treinador',
    editCoach: 'Editar Treinador',
    deleteCoach: 'Excluir Treinador',
    firstName: 'Primeiro Nome',
    lastName: 'Sobrenome',
    email: 'Email',
    phone: 'Telefone',
    experience: 'Experiência',
    specialization: 'Especialização',
    
    // Profile Management
    profile: 'Perfil',
    roleManagement: 'Gestão de Funções',
    clubRoles: 'Funções do Clube',
    permissions: 'Permissões',
    
    // Common
    save: 'Salvar',
    cancel: 'Cancelar',
    delete: 'Excluir',
    edit: 'Editar',
    add: 'Adicionar',
    create: 'Criar',
    update: 'Atualizar',
    search: 'Pesquisar',
    loading: 'Carregando...',
    success: 'Sucesso',
    error: 'Erro',
    confirmDelete: 'Tem certeza de que deseja excluir este item?',
    
    // Roles
    superAdmin: 'Super Administrador',
    admin: 'Administrador',
    coach: 'Treinador',
    player: 'Jogador',
    manager: 'Gerente',
    viewer: 'Visualizador'
  },
  ru: {
    // Navigation
    dashboard: 'Панель управления',
    teams: 'Команды',
    players: 'Игроки',
    coaches: 'Тренеры',
    analytics: 'Аналитика',
    calendar: 'Календарь',
    settings: 'Настройки',
    
    // Team Management
    teamManagement: 'Управление командами',
    addTeam: 'Добавить команду',
    editTeam: 'Редактировать команду',
    deleteTeam: 'Удалить команду',
    teamName: 'Название команды',
    sport: 'Вид спорта',
    status: 'Статус',
    description: 'Описание',
    
    // Coach Management
    coachManagement: 'Управление тренерами',
    addCoach: 'Добавить тренера',
    editCoach: 'Редактировать тренера',
    deleteCoach: 'Удалить тренера',
    firstName: 'Имя',
    lastName: 'Фамилия',
    email: 'Электронная почта',
    phone: 'Телефон',
    experience: 'Опыт',
    specialization: 'Специализация',
    
    // Profile Management
    profile: 'Профиль',
    roleManagement: 'Управление ролями',
    clubRoles: 'Роли клуба',
    permissions: 'Разрешения',
    
    // Common
    save: 'Сохранить',
    cancel: 'Отмена',
    delete: 'Удалить',
    edit: 'Редактировать',
    add: 'Добавить',
    create: 'Создать',
    update: 'Обновить',
    search: 'Поиск',
    loading: 'Загрузка...',
    success: 'Успех',
    error: 'Ошибка',
    confirmDelete: 'Вы уверены, что хотите удалить этот элемент?',
    
    // Roles
    superAdmin: 'Супер администратор',
    admin: 'Администратор',
    coach: 'Тренер',
    player: 'Игрок',
    manager: 'Менеджер',
    viewer: 'Наблюдатель'
  },
  zh: {
    // Navigation
    dashboard: '仪表板',
    teams: '团队',
    players: '球员',
    coaches: '教练',
    analytics: '分析',
    calendar: '日历',
    settings: '设置',
    
    // Team Management
    teamManagement: '团队管理',
    addTeam: '添加团队',
    editTeam: '编辑团队',
    deleteTeam: '删除团队',
    teamName: '团队名称',
    sport: '运动',
    status: '状态',
    description: '描述',
    
    // Coach Management
    coachManagement: '教练管理',
    addCoach: '添加教练',
    editCoach: '编辑教练',
    deleteCoach: '删除教练',
    firstName: '名',
    lastName: '姓',
    email: '电子邮件',
    phone: '电话',
    experience: '经验',
    specialization: '专业',
    
    // Profile Management
    profile: '个人资料',
    roleManagement: '角色管理',
    clubRoles: '俱乐部角色',
    permissions: '权限',
    
    // Common
    save: '保存',
    cancel: '取消',
    delete: '删除',
    edit: '编辑',
    add: '添加',
    create: '创建',
    update: '更新',
    search: '搜索',
    loading: '加载中...',
    success: '成功',
    error: '错误',
    confirmDelete: '您确定要删除此项目吗？',
    
    // Roles
    superAdmin: '超级管理员',
    admin: '管理员',
    coach: '教练',
    player: '球员',
    manager: '经理',
    viewer: '观察者'
  },
  ja: {
    // Navigation
    dashboard: 'ダッシュボード',
    teams: 'チーム',
    players: '選手',
    coaches: 'コーチ',
    analytics: '分析',
    calendar: 'カレンダー',
    settings: '設定',
    
    // Team Management
    teamManagement: 'チーム管理',
    addTeam: 'チーム追加',
    editTeam: 'チーム編集',
    deleteTeam: 'チーム削除',
    teamName: 'チーム名',
    sport: 'スポーツ',
    status: 'ステータス',
    description: '説明',
    
    // Coach Management
    coachManagement: 'コーチ管理',
    addCoach: 'コーチ追加',
    editCoach: 'コーチ編集',
    deleteCoach: 'コーチ削除',
    firstName: '名',
    lastName: '姓',
    email: 'メール',
    phone: '電話',
    experience: '経験',
    specialization: '専門分野',
    
    // Profile Management
    profile: 'プロフィール',
    roleManagement: '役割管理',
    clubRoles: 'クラブの役割',
    permissions: '権限',
    
    // Common
    save: '保存',
    cancel: 'キャンセル',
    delete: '削除',
    edit: '編集',
    add: '追加',
    create: '作成',
    update: '更新',
    search: '検索',
    loading: '読み込み中...',
    success: '成功',
    error: 'エラー',
    confirmDelete: 'この項目を削除してもよろしいですか？',
    
    // Roles
    superAdmin: 'スーパー管理者',
    admin: '管理者',
    coach: 'コーチ',
    player: '選手',
    manager: 'マネージャー',
    viewer: '閲覧者'
  },
  ar: {
    // Navigation
    dashboard: 'لوحة التحكم',
    teams: 'الفرق',
    players: 'اللاعبين',
    coaches: 'المدربين',
    analytics: 'التحليلات',
    calendar: 'التقويم',
    settings: 'الإعدادات',
    
    // Team Management
    teamManagement: 'إدارة الفرق',
    addTeam: 'إضافة فريق',
    editTeam: 'تعديل الفريق',
    deleteTeam: 'حذف الفريق',
    teamName: 'اسم الفريق',
    sport: 'الرياضة',
    status: 'الحالة',
    description: 'الوصف',
    
    // Coach Management
    coachManagement: 'إدارة المدربين',
    addCoach: 'إضافة مدرب',
    editCoach: 'تعديل المدرب',
    deleteCoach: 'حذف المدرب',
    firstName: 'الاسم الأول',
    lastName: 'اسم العائلة',
    email: 'البريد الإلكتروني',
    phone: 'الهاتف',
    experience: 'الخبرة',
    specialization: 'التخصص',
    
    // Profile Management
    profile: 'الملف الشخصي',
    roleManagement: 'إدارة الأدوار',
    clubRoles: 'أدوار النادي',
    permissions: 'الصلاحيات',
    
    // Common
    save: 'حفظ',
    cancel: 'إلغاء',
    delete: 'حذف',
    edit: 'تعديل',
    add: 'إضافة',
    create: 'إنشاء',
    update: 'تحديث',
    search: 'بحث',
    loading: 'جاري التحميل...',
    success: 'نجح',
    error: 'خطأ',
    confirmDelete: 'هل أنت متأكد من أنك تريد حذف هذا العنصر؟',
    
    // Roles
    superAdmin: 'مدير عام',
    admin: 'مدير',
    coach: 'مدرب',
    player: 'لاعب',
    manager: 'مدير',
    viewer: 'مشاهد'
  }
};

export const LanguageContext = createContext<{
  language: Language;
  setLanguage: (lang: Language) => void;
  t: (key: string) => string;
}>({
  language: 'en',
  setLanguage: () => {},
  t: (key: string) => key,
});

export const useTranslation = () => {
  const context = useContext(LanguageContext);
  if (!context) {
    throw new Error('useTranslation must be used within a LanguageProvider');
  }
  return context;
};