import { useAuth } from "./useAuth";
import { SPORTS, SPORT_FEATURES, SportType } from "@shared/sports";

export function useSport() {
  const { user } = useAuth();
  
  const currentSport = ((user as any)?.sport as SportType) || 'rugby';
  
  const getSportConfig = () => {
    return SPORT_FEATURES[currentSport];
  };
  
  const getSportPositions = () => {
    return [...(SPORT_FEATURES[currentSport]?.positions || [])];
  };
  
  const getSportFormations = () => {
    return [...(SPORT_FEATURES[currentSport]?.formations || [])];
  };
  
  const getSportTeamSize = () => {
    return SPORT_FEATURES[currentSport]?.teamSize || 11;
  };
  
  const hasUnlimitedSubstitutions = () => {
    return SPORT_FEATURES[currentSport]?.substitutions === "unlimited";
  };
  
  const getSportScoreTypes = () => {
    return [...(SPORT_FEATURES[currentSport]?.scoreTypes || [])];
  };
  
  const getSportName = () => {
    const sport = SPORTS.find(s => s.value === currentSport);
    return sport?.label || 'Rugby';
  };
  
  return {
    currentSport,
    sportName: getSportName(),
    sportConfig: getSportConfig(),
    positions: getSportPositions(),
    formations: getSportFormations(),
    teamSize: getSportTeamSize(),
    unlimitedSubs: hasUnlimitedSubstitutions(),
    scoreTypes: getSportScoreTypes(),
    isTeamSport: getSportTeamSize() > 1,
    SPORTS
  };
}