import { useState, useEffect } from "react";

const ONBOARDING_KEY = "sportspro_onboarding_completed";

export function useOnboarding() {
  const [showOnboarding, setShowOnboarding] = useState(false);
  const [isFirstVisit, setIsFirstVisit] = useState(false);

  useEffect(() => {
    const hasCompletedOnboarding = localStorage.getItem(ONBOARDING_KEY);
    const isFirstTime = !hasCompletedOnboarding;
    
    setIsFirstVisit(isFirstTime);
    setShowOnboarding(isFirstTime);
  }, []);

  const completeOnboarding = () => {
    localStorage.setItem(ONBOARDING_KEY, "true");
    setShowOnboarding(false);
    setIsFirstVisit(false);
  };

  const skipOnboarding = () => {
    localStorage.setItem(ONBOARDING_KEY, "true");
    setShowOnboarding(false);
    setIsFirstVisit(false);
  };

  const restartOnboarding = () => {
    localStorage.removeItem(ONBOARDING_KEY);
    setShowOnboarding(true);
    setIsFirstVisit(true);
  };

  return {
    showOnboarding,
    isFirstVisit,
    completeOnboarding,
    skipOnboarding,
    restartOnboarding,
  };
}