import { Badge } from "@/components/ui/badge";
import { useSport } from "@/hooks/useSport";
import { Trophy } from "lucide-react";

export function SportBadge() {
  const { sportName, currentSport } = useSport();
  
  const sportColors = {
    football: "bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-300",
    rugby: "bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-300",
    cricket: "bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-300",
    baseball: "bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-300",
    basketball: "bg-orange-100 text-orange-800 dark:bg-orange-900 dark:text-orange-300",
    hockey: "bg-purple-100 text-purple-800 dark:bg-purple-900 dark:text-purple-300",
    netball: "bg-pink-100 text-pink-800 dark:bg-pink-900 dark:text-pink-300",
    soccer: "bg-emerald-100 text-emerald-800 dark:bg-emerald-900 dark:text-emerald-300",
    badminton: "bg-indigo-100 text-indigo-800 dark:bg-indigo-900 dark:text-indigo-300",
    volleyball: "bg-cyan-100 text-cyan-800 dark:bg-cyan-900 dark:text-cyan-300",
  };
  
  return (
    <Badge className={`${sportColors[currentSport as keyof typeof sportColors]} border-0`}>
      <Trophy className="w-3 h-3 mr-1" />
      {sportName}
    </Badge>
  );
}