import React, { Suspense } from 'react';
import { Card, CardContent } from "@/components/ui/card";

interface LazyLoadComponentProps {
  children: React.ReactNode;
  fallback?: React.ReactNode;
}

const defaultFallback = (
  <Card className="h-64">
    <CardContent className="p-6">
      <div className="animate-pulse">
        <div className="h-4 bg-gray-200 rounded w-3/4 mb-4"></div>
        <div className="space-y-2">
          <div className="h-3 bg-gray-200 rounded"></div>
          <div className="h-3 bg-gray-200 rounded w-5/6"></div>
        </div>
      </div>
    </CardContent>
  </Card>
);

export function LazyLoadComponent({ children, fallback = defaultFallback }: LazyLoadComponentProps) {
  return (
    <Suspense fallback={fallback}>
      {children}
    </Suspense>
  );
}