import React from "react";
import { Button } from "@/components/ui/button";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Badge } from "@/components/ui/badge";
import { PlayCircle, Star, ArrowRight } from "lucide-react";

interface OnboardingTriggerProps {
  onStartTour: () => void;
}

export default function OnboardingTrigger({ onStartTour }: OnboardingTriggerProps) {
  return (
    <Card className="border-2 border-primary/20 bg-gradient-to-br from-primary/5 to-primary/10">
      <CardHeader className="text-center space-y-4">
        <div className="flex items-center justify-center">
          <Badge variant="secondary" className="bg-primary/10 text-primary border-primary/20">
            <Star className="h-3 w-3 mr-1" />
            New User
          </Badge>
        </div>
        
        <div className="flex flex-col items-center space-y-3">
          <div className="w-12 h-12 bg-primary/10 rounded-full flex items-center justify-center">
            <PlayCircle className="h-6 w-6 text-primary" />
          </div>
          
          <CardTitle className="text-xl font-bold text-gray-900">
            Take a Quick Tour
          </CardTitle>
        </div>
      </CardHeader>

      <CardContent className="text-center space-y-4">
        <CardDescription className="text-base leading-relaxed">
          New to SportsPro? Let us show you around! Take a 2-minute guided tour to discover 
          all the powerful features for managing your teams, players, and coaches.
        </CardDescription>

        <div className="space-y-3">
          <div className="grid grid-cols-2 gap-3 text-sm text-gray-600">
            <div className="flex items-center space-x-2">
              <div className="w-2 h-2 bg-primary rounded-full"></div>
              <span>Dashboard overview</span>
            </div>
            <div className="flex items-center space-x-2">
              <div className="w-2 h-2 bg-primary rounded-full"></div>
              <span>Team management</span>
            </div>
            <div className="flex items-center space-x-2">
              <div className="w-2 h-2 bg-primary rounded-full"></div>
              <span>Player profiles</span>
            </div>
            <div className="flex items-center space-x-2">
              <div className="w-2 h-2 bg-primary rounded-full"></div>
              <span>Coach assignments</span>
            </div>
          </div>

          <Button 
            onClick={onStartTour}
            className="w-full bg-primary hover:bg-primary/90 flex items-center space-x-2"
            size="lg"
          >
            <PlayCircle className="h-5 w-5" />
            <span>Start Tour</span>
            <ArrowRight className="h-4 w-4" />
          </Button>
        </div>
      </CardContent>
    </Card>
  );
}