import { Trophy, Facebook, Twitter, Linkedin, Instagram, Mail, Phone, MapPin, Clock } from "lucide-react";

export default function Footer() {
  return (
    <footer className="bg-white border-t border-gray-200 mt-12">
      <div className="px-4 sm:px-6 lg:px-8 py-8">
        <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 lg:gap-8">
          {/* Company Info */}
          <div className="col-span-1 sm:col-span-2 lg:col-span-2">
            <div className="flex items-center space-x-3 mb-4">
              <div className="w-8 h-8 bg-primary rounded-lg flex items-center justify-center">
                <Trophy className="text-white h-5 w-5" />
              </div>
              <h3 className="text-lg font-bold text-gray-900">SportsPro</h3>
            </div>
            <p className="text-gray-600 mb-4 text-sm sm:text-base max-w-md">
              Professional sports team management platform with advanced biometric integration 
              and comprehensive analytics for modern sports organizations.
            </p>
            <div className="flex space-x-4">
              <a href="#" className="text-gray-400 hover:text-primary transition-colors">
                <Facebook className="h-5 w-5" />
              </a>
              <a href="#" className="text-gray-400 hover:text-primary transition-colors">
                <Twitter className="h-5 w-5" />
              </a>
              <a href="#" className="text-gray-400 hover:text-primary transition-colors">
                <Linkedin className="h-5 w-5" />
              </a>
              <a href="#" className="text-gray-400 hover:text-primary transition-colors">
                <Instagram className="h-5 w-5" />
              </a>
            </div>
          </div>

          {/* Quick Links */}
          <div className="col-span-1">
            <h4 className="font-semibold text-gray-900 mb-3 sm:mb-4 text-sm sm:text-base">Quick Links</h4>
            <ul className="space-y-1 sm:space-y-2">
              <li><a href="/" className="text-gray-600 hover:text-primary transition-colors text-sm">Dashboard</a></li>
              <li><a href="/teams" className="text-gray-600 hover:text-primary transition-colors text-sm">Team Management</a></li>
              <li><a href="/players" className="text-gray-600 hover:text-primary transition-colors text-sm">Player Registry</a></li>
              <li><a href="/analytics" className="text-gray-600 hover:text-primary transition-colors text-sm">Analytics</a></li>
              <li><a href="/settings" className="text-gray-600 hover:text-primary transition-colors text-sm">Settings</a></li>
            </ul>
          </div>

          {/* Contact Info */}
          <div className="col-span-1">
            <h4 className="font-semibold text-gray-900 mb-3 sm:mb-4 text-sm sm:text-base">Contact Us</h4>
            <ul className="space-y-2 sm:space-y-2">
              <li className="flex items-start space-x-2 text-gray-600">
                <Mail className="h-4 w-4 mt-0.5 flex-shrink-0" />
                <span className="text-xs sm:text-sm break-all">support@sportspro.com</span>
              </li>
              <li className="flex items-start space-x-2 text-gray-600">
                <Phone className="h-4 w-4 mt-0.5 flex-shrink-0" />
                <span className="text-xs sm:text-sm">+1 (555) 123-4567</span>
              </li>
              <li className="flex items-start space-x-2 text-gray-600">
                <MapPin className="h-4 w-4 mt-0.5 flex-shrink-0" />
                <span className="text-xs sm:text-sm">123 Sports Ave, Athletic City</span>
              </li>
              <li className="flex items-start space-x-2 text-gray-600">
                <Clock className="h-4 w-4 mt-0.5 flex-shrink-0" />
                <span className="text-xs sm:text-sm">24/7 Support Available</span>
              </li>
            </ul>
          </div>
        </div>

        {/* Footer Bottom */}
        <div className="border-t border-gray-200 mt-6 sm:mt-8 pt-4 sm:pt-6">
          <div className="flex flex-col sm:flex-row justify-between items-center space-y-3 sm:space-y-0">
            <p className="text-gray-500 text-xs sm:text-sm text-center sm:text-left">
              © 2024 SportsPro. All rights reserved. Powered by advanced biometric technology.
            </p>
            <div className="flex flex-wrap justify-center sm:justify-end space-x-4 sm:space-x-6">
              <a href="#" className="text-gray-500 hover:text-primary text-xs sm:text-sm transition-colors">Privacy Policy</a>
              <a href="#" className="text-gray-500 hover:text-primary text-xs sm:text-sm transition-colors">Terms of Service</a>
              <a href="#" className="text-gray-500 hover:text-primary text-xs sm:text-sm transition-colors">Cookie Policy</a>
            </div>
          </div>
        </div>
      </div>
    </footer>
  );
}
