import { useEffect } from "react";
import { useAccessibility } from "./accessibility-provider";

// Screen reader announcements for accessibility changes
export function AccessibilityAnnouncement() {
  const { settings } = useAccessibility();

  useEffect(() => {
    // Create or update the live region for screen reader announcements
    let liveRegion = document.getElementById('accessibility-announcements');
    
    if (!liveRegion) {
      liveRegion = document.createElement('div');
      liveRegion.id = 'accessibility-announcements';
      liveRegion.setAttribute('aria-live', 'polite');
      liveRegion.setAttribute('aria-atomic', 'true');
      liveRegion.style.position = 'absolute';
      liveRegion.style.left = '-10000px';
      liveRegion.style.width = '1px';
      liveRegion.style.height = '1px';
      liveRegion.style.overflow = 'hidden';
      document.body.appendChild(liveRegion);
    }

    const announcements = [];
    
    if (settings.highContrast) {
      announcements.push("High contrast mode enabled");
    }
    
    if (settings.reducedMotion) {
      announcements.push("Reduced motion enabled");
    }
    
    if (settings.largeText) {
      announcements.push("Large text mode enabled");
    }
    
    if (settings.screenReaderMode) {
      announcements.push("Screen reader mode enabled");
    }

    if (announcements.length > 0) {
      liveRegion.textContent = announcements.join(", ");
      
      // Clear the announcement after a delay
      setTimeout(() => {
        if (liveRegion) {
          liveRegion.textContent = "";
        }
      }, 1000);
    }
  }, [settings]);

  return null; // This component doesn't render anything visible
}