# SportsPro - Advanced Sports Management Platform

A next-generation sports management ecosystem designed for professional organizations with enterprise-grade functionality, comprehensive team operations, and advanced deployment capabilities.

## Features

### 🎯 Advanced Roster Management
- **Drag & Drop Interface**: Intuitive player position assignment with visual feedback and smooth animations
- **Position Reassignment**: Move players between field positions, substitutes, and available players seamlessly
- **Formation Support**: Multiple sport formations (Rugby 15s, 7s, 10s) with tactical positioning
- **Real-time Updates**: Live roster changes with immediate visual confirmation

### 📊 Comprehensive Analytics & Coaching
- **Performance Dashboard**: Real-time statistics and interactive charts for teams and players
- **Biometric Integration**: Advanced health monitoring and performance tracking
- **Coaching Tools**: Interactive tactical planning and performance analysis dashboard
- **Progress Tracking**: Detailed player development and team performance metrics

### 🏆 Gamification & Engagement
- **Achievement System**: Comprehensive challenge and progress tracking with leaderboards
- **Performance Challenges**: Customizable goals and milestones for players and teams
- **Interactive Statistics**: Visual progress charts and performance comparisons
- **Motivation Tools**: Engagement features to boost team morale and participation

### 💬 Club Communication System
- **Newsletter Management**: Automated newsletter creation and distribution
- **Announcements**: Club-wide messaging and notification system
- **Member Engagement**: Interactive communication tools for organization members
- **Event Management**: Comprehensive event planning and communication features

### 💳 Subscription & Payment Management
- **Organization-based Billing**: Multi-tier subscription system (Premium/Regular)
- **Automated Payments**: Secure payment processing with Stripe integration
- **Membership Management**: Complete fee tracking and subscription oversight
- **Financial Reporting**: Detailed payment and subscription analytics

### 👥 Unified Profile System
- **Multi-role Support**: Single dashboard for players, coaches, administrators, and members
- **Role-based Permissions**: Customizable access control based on organization roles
- **Profile Unification**: Seamless role switching within single user accounts
- **User Management**: Comprehensive admin tools with automated onboarding

### 🌍 Enterprise Features
- **Internationalization**: Multi-language support for global organizations
- **Admin User Management**: Advanced user creation with automated password generation
- **Email Integration**: Automated welcome emails and password reset functionality
- **Documentation System**: Complete user onboarding and help documentation

### 🔒 Security & Deployment
- **VPS Deployment Ready**: Complete installation guides for professional deployment
- **Shared Hosting Support**: cPanel and hosting platform compatibility
- **Enterprise Security**: Advanced authentication and data protection
- **Scalable Architecture**: Designed for professional sports organizations

## Accessibility Features

The application includes comprehensive accessibility support:

### High Contrast Mode
- Enhanced color contrast for better visibility
- Optimized for users with visual impairments
- Works with both light and dark themes

### Reduced Motion
- Minimizes animations and transitions
- Auto-detects system `prefers-reduced-motion` setting
- Improves experience for users sensitive to motion

### Large Text Mode
- Increases font sizes throughout the application
- Scalable text for better readability
- Maintains design integrity

### Screen Reader Support
- Enhanced focus indicators
- ARIA labels and descriptions
- Live region announcements for setting changes
- Semantic HTML structure

### Keyboard Navigation
- Enhanced focus indicators
- Keyboard shortcuts support
- Tab navigation optimization
- Focus management

## Technology Stack

### Frontend
- **React 18** with TypeScript
- **Tailwind CSS** for styling
- **shadcn/ui** component library
- **Wouter** for routing
- **TanStack Query** for data fetching
- **React Hook Form** for form management
- **Recharts** for data visualization

### Backend
- **Express.js** with TypeScript
- **PostgreSQL** database
- **Drizzle ORM** for database operations
- **Passport.js** for authentication
- **Replit Auth** integration

### Development
- **Vite** for build tooling
- **ESLint** and **TypeScript** for code quality
- **Hot Module Replacement** for development

## Getting Started

### Prerequisites
- Node.js (18+ recommended)
- PostgreSQL database
- Replit account (for authentication)

### Installation

1. Clone the repository
2. Install dependencies:
   ```bash
   npm install
   ```

3. Set up environment variables:
   - `DATABASE_URL` - PostgreSQL connection string
   - `SESSION_SECRET` - Session encryption key
   - `REPL_ID` - Replit application ID
   - `REPLIT_DOMAINS` - Allowed domains for OAuth

4. Initialize the database:
   ```bash
   npm run db:push
   ```

5. Start the development server:
   ```bash
   npm run dev
   ```

The application will be available at `http://localhost:5000`

## Production Deployment

### 🚀 VPS Deployment

For production deployment on a VPS (Ubuntu/CentOS), follow the comprehensive guide:

**Quick Setup:**
```bash
# System preparation
sudo apt update && sudo apt upgrade -y
sudo apt install -y curl wget git nginx postgresql postgresql-contrib

# Node.js installation
curl -fsSL https://deb.nodesource.com/setup_20.x | sudo -E bash -
sudo apt-get install -y nodejs

# PM2 process manager
sudo npm install -g pm2

# Application setup
git clone <your-repo-url> sports-platform
cd sports-platform
npm install
npm run build

# Database setup
sudo -u postgres createdb sports_platform
sudo -u postgres createuser sportsapp -P

# Environment configuration
cp .env.example .env.production
# Edit .env.production with production settings

# Database migration
npm run db:push

# Start application
pm2 start ecosystem.config.js
pm2 save
```

**Complete Guide:** See [INSTALLATION_GUIDE.md](./INSTALLATION_GUIDE.md) for detailed instructions including:
- SSL certificate setup with Let's Encrypt
- Nginx reverse proxy configuration
- Security hardening and firewall setup
- Monitoring and maintenance procedures
- Troubleshooting common deployment issues

**Quick Reference:** See [DEPLOYMENT_QUICK_START.md](./DEPLOYMENT_QUICK_START.md) for essential commands and configuration snippets.

### 🏠 Shared Hosting Deployment

For shared hosting platforms with cPanel:

1. **Upload Files:** Extract application to `public_html` directory
2. **Node.js Setup:** Enable Node.js 18.x+ in hosting control panel
3. **Database:** Create PostgreSQL/MySQL database through hosting interface
4. **Environment:** Configure variables in Node.js application settings
5. **Dependencies:** Run `npm install --production` via terminal/SSH
6. **Migration:** Execute `npm run db:push` to initialize database
7. **Launch:** Start application through hosting control panel

### 📋 Environment Variables

Required for production deployment:

```env
NODE_ENV=production
PORT=5000
DATABASE_URL=postgresql://username:password@host:port/database
SESSION_SECRET=your_very_long_random_session_secret
REPL_ID=your_replit_application_id
REPLIT_DOMAINS=yourdomain.com,www.yourdomain.com

# Optional: Email integration
SENDGRID_API_KEY=your_sendgrid_api_key

# Optional: Payment processing
STRIPE_SECRET_KEY=your_stripe_secret_key
VITE_STRIPE_PUBLIC_KEY=your_stripe_public_key
```

### 🔧 Production Management

**Process Management with PM2:**
```bash
pm2 start sports-platform    # Start application
pm2 restart sports-platform  # Restart application
pm2 logs sports-platform     # View logs
pm2 monit                    # Monitor performance
```

**Database Maintenance:**
```bash
npm run db:push              # Apply schema changes
pg_dump $DATABASE_URL > backup.sql  # Create backup
```

**Health Monitoring:**
```bash
curl -f http://localhost:5000/api/health || echo "Service down"
```

## Database Schema

### Core Tables
- **users** - User authentication and profile data
- **teams** - Rugby team information
- **players** - Player profiles and statistics
- **coaches** - Coach information and assignments
- **tournaments** - Tournament management
- **matches** - Match scheduling and results

### Relationships
- Players belong to teams
- Coaches are assigned to teams via team_coaches junction table
- Tournaments contain multiple matches
- Matches are between teams

## API Endpoints

### Authentication
- `GET /api/auth/user` - Get current user
- `PUT /api/auth/user` - Update user profile
- `GET /api/login` - OAuth login
- `GET /api/logout` - Logout

### Teams
- `GET /api/teams` - List all teams
- `POST /api/teams` - Create team
- `PUT /api/teams/:id` - Update team
- `DELETE /api/teams/:id` - Delete team

### Players
- `GET /api/players` - List all players
- `POST /api/players` - Create player
- `PUT /api/players/:id` - Update player
- `DELETE /api/players/:id` - Delete player

### Tournaments
- `GET /api/tournaments` - List tournaments
- `POST /api/tournaments` - Create tournament
- `PUT /api/tournaments/:id` - Update tournament
- `DELETE /api/tournaments/:id` - Delete tournament

### Analytics
- `GET /api/dashboard/stats` - Dashboard statistics
- `GET /api/data/export` - Export system data

## Configuration

### Theme Settings
Users can customize their experience through the Settings page:
- Light/Dark/System theme preference
- Accessibility options
- Notification preferences
- Language and timezone settings

### Accessibility Settings
- High Contrast Mode toggle
- Reduced Motion preference
- Large Text scaling
- Screen Reader optimizations
- Enhanced Keyboard Navigation

## Development Guidelines

### Code Structure
- `/client` - React frontend application
- `/server` - Express.js backend API
- `/shared` - Shared TypeScript types and schemas
- `/components` - Reusable UI components

### Database Changes
Use Drizzle ORM for schema changes:
```bash
npm run db:push
```

### Adding New Features
1. Define types in `/shared/schema.ts`
2. Update storage interface in `/server/storage.ts`
3. Add API routes in `/server/routes.ts`
4. Create frontend components and pages
5. Update navigation and routing

## Deployment

The application is designed for deployment on Replit with:
- Automatic SSL/TLS certificates
- Health check monitoring
- Custom domain support
- Environment variable management

## Contributing

1. Follow TypeScript best practices
2. Use semantic commit messages
3. Ensure accessibility compliance
4. Test all features thoroughly
5. Update documentation for new features

## Security

- OAuth authentication via Replit
- Session-based user management
- SQL injection prevention via Drizzle ORM
- Input validation on all endpoints
- Secure file upload handling

## License

This project is proprietary and confidential. All rights reserved.