# SportsPro Installation Guide

## Quick Start Installation

### Prerequisites
- Node.js 20.x or higher
- PostgreSQL 14.x or higher
- Git

### Local Development Setup

1. **Clone the repository**
```bash
git clone https://github.com/your-repo/sportspro.git
cd sportspro
```

2. **Install dependencies**
```bash
npm install
```

3. **Configure environment**
```bash
cp .env.example .env
```

Edit `.env` with your configuration:
```env
DATABASE_URL=postgresql://username:password@localhost:5432/sportspro
SESSION_SECRET=your-secure-session-secret-minimum-32-characters
SENDGRID_API_KEY=your-sendgrid-api-key
```

4. **Setup database**
```bash
# Create database
createdb sportspro

# Run migrations
npm run db:push

# Optional: Seed sample data
npm run seed
```

5. **Start development server**
```bash
npm run dev
```

Visit `http://localhost:5000` to access SportsPro.

### Production Deployment

For production deployment on your own domain, see [DEPLOYMENT_GUIDE.md](./DEPLOYMENT_GUIDE.md) for complete VPS setup instructions.

### Docker Installation

```bash
# Using Docker Compose
docker-compose up -d

# Or build manually
docker build -t sportspro .
docker run -p 5000:5000 --env-file .env sportspro
```

### Environment Variables

| Variable | Description | Required |
|----------|-------------|----------|
| `DATABASE_URL` | PostgreSQL connection string | Yes |
| `SESSION_SECRET` | Session encryption key | Yes |
| `SENDGRID_API_KEY` | Email service API key | No |
| `SMTP_HOST` | SMTP server host | No |
| `SMTP_USERNAME` | SMTP username | No |
| `SMTP_PASSWORD` | SMTP password | No |
| `NODE_ENV` | Environment (development/production) | Yes |

### Troubleshooting

**Database connection issues:**
- Verify PostgreSQL is running: `sudo systemctl status postgresql`
- Check connection string format
- Ensure database exists

**Build errors:**
- Clear npm cache: `npm cache clean --force`
- Delete node_modules: `rm -rf node_modules && npm install`
- Check Node.js version: `node --version`

**Email not working:**
- Verify SMTP credentials
- Check firewall settings
- Test with different email provider

### Support

For installation help, check the documentation at `/help` in your SportsPro instance or contact support.