# SportsPro cPanel Installation Guide

## Overview
This guide provides step-by-step instructions for installing SportsPro on your personal hosting account using cPanel. SportsPro is a Node.js application that requires specific server configurations.

## Prerequisites

### Server Requirements
- **Node.js**: Version 18.x or higher
- **PostgreSQL**: Version 12 or higher
- **Memory**: Minimum 1GB RAM (2GB recommended)
- **Storage**: At least 2GB free space
- **SSL Certificate**: Required for production

### cPanel Requirements
- cPanel with Node.js support enabled
- SSH access (recommended but not required)
- File Manager access
- Database management tools

## Step 1: Verify Node.js Support

1. **Check Node.js Availability**
   - Log into your cPanel
   - Look for "Node.js" or "Node.js App" in the Software section
   - If not available, contact your hosting provider to enable Node.js

2. **Verify Version**
   - Click on Node.js App
   - Check available Node.js versions
   - Ensure version 18.x or higher is available

## Step 2: Create PostgreSQL Database

1. **Access Database Section**
   - Go to cPanel → Databases → PostgreSQL Databases
   - If PostgreSQL is not available, contact hosting support

2. **Create Database**
   ```
   Database Name: sportspro_db
   ```

3. **Create Database User**
   ```
   Username: sportspro_user
   Password: [Generate strong password]
   ```

4. **Grant Privileges**
   - Assign ALL PRIVILEGES to sportspro_user for sportspro_db
   - Note down the connection details:
     - Host: localhost (or provided host)
     - Port: 5432 (or provided port)
     - Database: sportspro_db
     - Username: sportspro_user
     - Password: [your password]

## Step 3: Upload Application Files

### Method A: Using File Manager (Recommended)

1. **Prepare Files**
   - Download the SportsPro application as a ZIP file
   - Ensure all source files are included

2. **Upload via File Manager**
   - Go to cPanel → File Manager
   - Navigate to your domain's document root (usually public_html)
   - Create a new folder: `sportspro`
   - Upload and extract the ZIP file into this folder

### Method B: Using SSH (Advanced)

1. **Connect via SSH**
   ```bash
   ssh username@yourdomain.com
   cd public_html
   mkdir sportspro
   cd sportspro
   ```

2. **Clone Repository**
   ```bash
   git clone [repository-url] .
   ```

## Step 4: Configure Node.js Application

1. **Access Node.js App Manager**
   - Go to cPanel → Software → Node.js App
   - Click "Create App"

2. **Application Settings**
   ```
   Node.js Version: 18.x (latest available)
   Application Mode: Production
   Application Root: public_html/sportspro
   Application URL: sportspro (or your preferred subdomain)
   Application Startup File: server/index.js
   ```

3. **Click "Create"**

## Step 5: Install Dependencies

1. **Access App Terminal**
   - In Node.js App manager, click on your app
   - Click "Open Terminal" or use SSH

2. **Install Packages**
   ```bash
   npm install
   ```

3. **Install Development Dependencies**
   ```bash
   npm install --production=false
   ```

## Step 6: Environment Configuration

1. **Create Environment File**
   - In File Manager, create `.env` file in application root
   - Copy the following template:

   ```env
   # Database Configuration
   DATABASE_URL=postgresql://sportspro_user:YOUR_PASSWORD@localhost:5432/sportspro_db

   # Session Configuration
   SESSION_SECRET=YOUR_SUPER_SECRET_KEY_HERE_MINIMUM_32_CHARACTERS

   # Application Settings
   NODE_ENV=production
   PORT=3000

   # Email Configuration (Optional)
   SENDGRID_API_KEY=your_sendgrid_api_key_here

   # Domain Configuration
   DOMAIN=yourdomain.com
   PROTOCOL=https
   ```

2. **Update Values**
   - Replace `YOUR_PASSWORD` with your database password
   - Generate a strong SESSION_SECRET (32+ characters)
   - Update `yourdomain.com` with your actual domain
   - Add SendGrid API key if using email features

## Step 7: Database Setup

1. **Run Database Migrations**
   ```bash
   npm run db:push
   ```

2. **Verify Database Connection**
   ```bash
   npm run db:check
   ```

## Step 8: Build Application

1. **Build Frontend**
   ```bash
   npm run build
   ```

2. **Verify Build**
   - Check that `dist` folder is created
   - Ensure no build errors

## Step 9: Configure Startup

1. **Update Startup Script**
   - In Node.js App manager, set startup file to:
   ```
   server/index.js
   ```

2. **Set Environment Variables**
   - In Node.js App interface, add environment variables:
     - `NODE_ENV`: `production`
     - `PORT`: `3000`

## Step 10: Start Application

1. **Start the App**
   - In Node.js App manager, click "Start App"
   - Monitor for any errors in the log

2. **Test Application**
   - Visit: `https://yourdomain.com/sportspro`
   - You should see the SportsPro login page

## Step 11: SSL Configuration

1. **Enable SSL/TLS**
   - Go to cPanel → Security → SSL/TLS
   - Install SSL certificate for your domain
   - Enable "Force HTTPS Redirect"

2. **Update Application URLs**
   - Ensure all internal links use HTTPS
   - Update `.env` file if needed

## Step 12: Create Super Admin Account

1. **Access Application**
   - Go to: `https://yourdomain.com/sportspro/auth`

2. **Login with Default Credentials**
   ```
   Email: admin@sportspro.com
   Password: superadmin123
   ```

3. **Change Default Password**
   - Go to Profile settings
   - Update password immediately for security

## Step 13: Performance Optimization

### Enable Compression
1. **Add .htaccess File**
   - Create `.htaccess` in public_html/sportspro:
   ```apache
   # Enable Gzip Compression
   <IfModule mod_deflate.c>
       AddOutputFilterByType DEFLATE text/html text/plain text/xml text/css text/javascript application/javascript application/json
   </IfModule>

   # Browser Caching
   <IfModule mod_expires.c>
       ExpiresActive On
       ExpiresByType text/css "access plus 1 month"
       ExpiresByType application/javascript "access plus 1 month"
       ExpiresByType image/png "access plus 1 month"
       ExpiresByType image/jpg "access plus 1 month"
       ExpiresByType image/jpeg "access plus 1 month"
   </IfModule>
   ```

### Memory Optimization
1. **Set Memory Limits**
   - In Node.js App settings, increase memory if available
   - Monitor memory usage in app logs

## Step 14: Security Hardening

1. **File Permissions**
   ```bash
   chmod 644 .env
   chmod 755 server/
   chmod 644 package.json
   ```

2. **Hide Sensitive Files**
   - Add to `.htaccess`:
   ```apache
   # Deny access to sensitive files
   <Files ".env">
       Order allow,deny
       Deny from all
   </Files>
   ```

3. **Update Default Credentials**
   - Change all default passwords
   - Enable two-factor authentication if available

## Step 15: Backup Configuration

1. **Database Backup**
   ```bash
   pg_dump sportspro_db > backup_$(date +%Y%m%d).sql
   ```

2. **File Backup**
   - Use cPanel backup tools
   - Schedule regular backups
   - Store backups off-site

## Troubleshooting

### Common Issues

1. **Node.js App Won't Start**
   - Check Node.js version compatibility
   - Verify all dependencies are installed
   - Check application logs for errors

2. **Database Connection Failed**
   - Verify database credentials in `.env`
   - Check PostgreSQL service status
   - Ensure database user has correct privileges

3. **Build Errors**
   - Clear node_modules and reinstall
   - Check for missing dependencies
   - Verify Node.js version

4. **Permission Errors**
   - Check file ownership and permissions
   - Ensure write access to required directories

### Log Files Locations
- Application logs: Check Node.js App manager
- Error logs: cPanel → Error Logs
- Access logs: cPanel → Raw Access Logs

### Support Resources
- cPanel Documentation
- Hosting Provider Support
- SportsPro Documentation

## Maintenance

### Regular Tasks
1. **Update Dependencies**
   ```bash
   npm update
   npm audit fix
   ```

2. **Database Maintenance**
   - Regular backups
   - Performance monitoring
   - Index optimization

3. **Security Updates**
   - Monitor for security patches
   - Update passwords regularly
   - Review access logs

### Performance Monitoring
- Monitor memory usage
- Check response times
- Review error rates
- Database performance

## Advanced Configuration

### Custom Domain Setup
1. **Subdomain Configuration**
   - Create subdomain in cPanel
   - Point to application directory
   - Update DNS if needed

2. **CDN Integration**
   - Configure Cloudflare or similar
   - Update static asset URLs
   - Enable caching rules

### Email Configuration
1. **SendGrid Setup**
   - Create SendGrid account
   - Generate API key
   - Add to `.env` file

2. **SMTP Configuration**
   - Use hosting provider's SMTP
   - Configure in application settings

## Conclusion

This guide covers the complete installation process for SportsPro on cPanel hosting. Follow each step carefully and ensure all prerequisites are met. For additional support, consult your hosting provider's documentation or contact their support team.

Remember to:
- Keep all software updated
- Monitor application performance
- Maintain regular backups
- Follow security best practices

Your SportsPro installation should now be running successfully on your cPanel hosting environment.